/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.MasterCoverageRepository;
import com.github.terma.jenkins.githubprcoveragestatus.Message;
import com.github.terma.jenkins.githubprcoveragestatus.PrIdAndUrlUtils;
import com.github.terma.jenkins.githubprcoveragestatus.ServiceRegistry;
import com.github.terma.jenkins.githubprcoveragestatus.SettingsRepository;
import com.github.terma.jenkins.githubprcoveragestatus.Utils;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.Launcher;
import hudson.model.AbstractProject;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.BuildStepMonitor;
import hudson.tasks.Publisher;
import hudson.tasks.Recorder;
import java.io.IOException;
import java.io.PrintStream;
import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import jenkins.tasks.SimpleBuildStep;
import org.kohsuke.github.GHCommitState;
import org.kohsuke.github.GHPullRequestCommitDetail;
import org.kohsuke.github.GHRepository;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class CompareCoverageAction
extends Recorder
implements SimpleBuildStep {
    public static final String BUILD_LOG_PREFIX = "[GitHub PR Status] ";
    private static final long serialVersionUID = 1L;
    private String sonarLogin;
    private String sonarPassword;
    private Map<String, String> scmVars;
    private String jacocoCoverageCounter;
    private String publishResultAs;

    @DataBoundConstructor
    public CompareCoverageAction() {
    }

    public String getPublishResultAs() {
        return this.publishResultAs;
    }

    @DataBoundSetter
    public void setPublishResultAs(String publishResultAs) {
        this.publishResultAs = publishResultAs;
    }

    public String getSonarLogin() {
        return this.sonarLogin;
    }

    @DataBoundSetter
    public void setSonarLogin(String sonarLogin) {
        this.sonarLogin = sonarLogin;
    }

    public String getSonarPassword() {
        return this.sonarPassword;
    }

    @DataBoundSetter
    public void setSonarPassword(String sonarPassword) {
        this.sonarPassword = sonarPassword;
    }

    public Map<String, String> getScmVars() {
        return this.scmVars;
    }

    @DataBoundSetter
    public void setScmVars(Map<String, String> scmVars) {
        this.scmVars = scmVars;
    }

    public String getJacocoCoverageCounter() {
        return this.jacocoCoverageCounter;
    }

    @DataBoundSetter
    public void setJacocoCoverageCounter(String jacocoCoverageCounter) {
        this.jacocoCoverageCounter = jacocoCoverageCounter;
    }

    public void perform(Run build, FilePath workspace, Launcher launcher, TaskListener listener) throws InterruptedException, IOException {
        PrintStream buildLog = listener.getLogger();
        if (build.getResult() != Result.SUCCESS) {
            buildLog.println("[GitHub PR Status] skip, build is red");
            return;
        }
        buildLog.println("[GitHub PR Status] start");
        SettingsRepository settingsRepository = ServiceRegistry.getSettingsRepository();
        int prId = PrIdAndUrlUtils.getPrId(this.scmVars, build, listener);
        String gitUrl = PrIdAndUrlUtils.getGitUrl(this.scmVars, build, listener);
        buildLog.println("[GitHub PR Status] getting master coverage...");
        MasterCoverageRepository masterCoverageRepository = ServiceRegistry.getMasterCoverageRepository(buildLog, this.sonarLogin, this.sonarPassword);
        GHRepository gitHubRepository = ServiceRegistry.getPullRequestRepository().getGitHubRepository(gitUrl);
        float masterCoverage = masterCoverageRepository.get(gitUrl);
        buildLog.println("[GitHub PR Status] master coverage: " + masterCoverage);
        buildLog.println("[GitHub PR Status] collecting coverage...");
        float coverage = ServiceRegistry.getCoverageRepository(settingsRepository.isDisableSimpleCov(), this.jacocoCoverageCounter).get(workspace);
        buildLog.println("[GitHub PR Status] build coverage: " + coverage);
        Message message = new Message(coverage, masterCoverage);
        buildLog.println(BUILD_LOG_PREFIX + message.forConsole());
        String buildUrl = Utils.getBuildUrl(build, listener);
        String jenkinsUrl = settingsRepository.getJenkinsUrl();
        if (jenkinsUrl == null) {
            jenkinsUrl = Utils.getJenkinsUrlFromBuildUrl(buildUrl);
        }
        if ("comment".equalsIgnoreCase(this.publishResultAs)) {
            buildLog.println("[GitHub PR Status] publishing result as comment");
            this.publishComment(message, buildUrl, jenkinsUrl, settingsRepository, gitHubRepository, prId, listener);
        } else {
            buildLog.println("[GitHub PR Status] publishing result as status check");
            this.publishStatusCheck(message, gitHubRepository, prId, masterCoverage, coverage, buildUrl, listener);
        }
    }

    private void publishComment(Message message, String buildUrl, String jenkinsUrl, SettingsRepository settingsRepository, GHRepository gitHubRepository, int prId, TaskListener listener) {
        try {
            String comment = message.forComment(buildUrl, jenkinsUrl, settingsRepository.getYellowThreshold(), settingsRepository.getGreenThreshold(), settingsRepository.isPrivateJenkinsPublicGitHub());
            ServiceRegistry.getPullRequestRepository().comment(gitHubRepository, prId, comment);
        }
        catch (Exception ex) {
            PrintWriter pw = listener.error("Couldn't add comment to pull request #" + prId + "!");
            ex.printStackTrace(pw);
        }
    }

    private void publishStatusCheck(Message message, GHRepository gitHubRepository, int prId, float targetCoverage, float coverage, String buildUrl, TaskListener listener) {
        try {
            String text = message.forStatusCheck();
            List commits = gitHubRepository.getPullRequest(prId).listCommits().asList();
            ServiceRegistry.getPullRequestRepository().createCommitStatus(gitHubRepository, ((GHPullRequestCommitDetail)commits.get(commits.size() - 1)).getSha(), coverage < targetCoverage ? GHCommitState.FAILURE : GHCommitState.SUCCESS, buildUrl, message.forStatusCheck());
        }
        catch (Exception e) {
            PrintWriter pw = listener.error("Couldn't add status check to pull request #" + prId + "!");
            e.printStackTrace(pw);
        }
    }

    public BuildStepMonitor getRequiredMonitorService() {
        return BuildStepMonitor.NONE;
    }

    @Extension
    public static class DescriptorImpl
    extends BuildStepDescriptor<Publisher> {
        @NonNull
        public String getDisplayName() {
            return "Publish coverage to GitHub";
        }

        public boolean isApplicable(Class<? extends AbstractProject> jobType) {
            return true;
        }
    }
}

