/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.CoverageReportParser;
import java.io.File;
import java.io.IOException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.io.FileUtils;

class CoberturaParser
implements CoverageReportParser {
    CoberturaParser() {
    }

    private static String findFirst(String string, String pattern) {
        String result = CoberturaParser.findFirstOrNull(string, pattern);
        if (result != null) {
            return result;
        }
        throw new IllegalArgumentException("Can't find " + pattern + " in " + string);
    }

    private static String findFirstOrNull(String string, String pattern) {
        Matcher matcher = Pattern.compile(pattern).matcher(string);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    @Override
    public float get(String coberturaFilePath) {
        try {
            String content = FileUtils.readFileToString((File)new File(coberturaFilePath));
            float lineRate = Float.parseFloat(CoberturaParser.findFirst(content, "line-rate=['\"]([0-9.]+)['\"]"));
            float branchRate = Float.parseFloat(CoberturaParser.findFirst(content, "branch-rate=['\"]([0-9.]+)['\"]"));
            if (lineRate > 0.0f && branchRate == 0.0f) {
                return lineRate;
            }
            if (lineRate == 0.0f && branchRate > 0.0f) {
                return branchRate;
            }
            return lineRate / 2.0f + branchRate / 2.0f;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

