/*
 * Decompiled with CFR 0.152.
 */
package com.github.terma.jenkins.githubprcoveragestatus;

import com.github.terma.jenkins.githubprcoveragestatus.CoverageReportParser;
import com.github.terma.jenkins.githubprcoveragestatus.XmlUtils;
import java.io.File;
import java.io.IOException;
import org.apache.commons.io.FileUtils;

class CloverParser
implements CoverageReportParser {
    private static final String TOTAL_STATEMENTS_XPATH = "/coverage/project/metrics/@statements";
    private static final String COVER_STATEMENTS_XPATH = "/coverage/project/metrics/@coveredstatements";

    CloverParser() {
    }

    private int getByXpath(String filePath, String content, String xpath) {
        try {
            return Integer.parseInt(XmlUtils.findInXml(content, xpath));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Strange Clover report!\nFile path: " + filePath + "\nCan't extract float value by XPath: " + xpath + "\nfrom:\n" + content, e);
        }
    }

    @Override
    public float get(String cloverFilePath) {
        String content;
        try {
            content = FileUtils.readFileToString((File)new File(cloverFilePath));
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Can't read Clover report by path: " + cloverFilePath);
        }
        float statements = this.getByXpath(cloverFilePath, content, TOTAL_STATEMENTS_XPATH);
        float coveredStatements = this.getByXpath(cloverFilePath, content, COVER_STATEMENTS_XPATH);
        if (statements == 0.0f) {
            return 0.0f;
        }
        return coveredStatements / statements;
    }
}

