/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.adobe.jenkins.github_pr_comment_build.BasePRGHEventSubscriber;
import com.adobe.jenkins.github_pr_comment_build.GitHubPullRequestLabelCause;
import com.adobe.jenkins.github_pr_comment_build.TriggerPRLabelBranchProperty;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import net.sf.json.JSONObject;
import org.kohsuke.github.GHEvent;

@Extension
public class IssueLabelGHEventSubscriber
extends BasePRGHEventSubscriber<TriggerPRLabelBranchProperty, Void> {
    private static final Logger LOGGER = Logger.getLogger(IssueLabelGHEventSubscriber.class.getName());
    private static final String ACTION_LABELED = "labeled";

    @Override
    protected Class<TriggerPRLabelBranchProperty> getTriggerClass() {
        return TriggerPRLabelBranchProperty.class;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        JSONObject pullRequest = json.getJSONObject("pull_request");
        String pullRequestUrl = pullRequest.getString("html_url");
        int pullRequestId = pullRequest.getInt("number");
        String labellingAuthor = json.getJSONObject("sender").getString("login");
        LOGGER.fine(() -> String.format("PR Review Author: %s", labellingAuthor));
        String action = json.getString("action");
        if (!ACTION_LABELED.equals(action)) {
            LOGGER.log(Level.FINER, "Event is not labeled ({0}) for PR {1}, ignoring", new Object[]{action, pullRequestUrl});
            return;
        }
        String label = json.getJSONObject("label").getString("name");
        String labelUrl = json.getJSONObject("label").getString("url");
        String repoUrl = this.getRepoUrl(json);
        GitHubRepositoryName changedRepository = this.getChangedRepository(repoUrl);
        if (changedRepository == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Received label on PR {0} for {1}", new Object[]{pullRequestId, repoUrl});
        this.checkAndRunJobs(changedRepository, pullRequestId, labellingAuthor, null, (job, branchProp) -> {
            String expectedLabel = branchProp.getLabel();
            Pattern pattern = Pattern.compile(expectedLabel, 34);
            if (pattern.matcher(label).matches()) {
                return new GitHubPullRequestLabelCause(labelUrl, labellingAuthor, label);
            }
            LOGGER.log(Level.FINER, "Label does not match the trigger build label string ({0}) for {1}", new Object[]{expectedLabel, job.getFullName()});
            return null;
        });
    }
}

