/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import hudson.model.Cause;
import java.io.Serializable;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;

public final class GitHubPullRequestReviewCause
extends Cause
implements Serializable {
    private final String reviewAuthor;
    private final String pullRequestUrl;

    public GitHubPullRequestReviewCause(String reviewAuthor, String pullRequestUrl) {
        this.reviewAuthor = reviewAuthor;
        this.pullRequestUrl = pullRequestUrl;
    }

    @Whitelisted
    public String getShortDescription() {
        return String.format("GitHub pull request review by %s", this.reviewAuthor);
    }

    @Whitelisted
    @Exported(visibility=3)
    public String getReviewAuthor() {
        return this.reviewAuthor;
    }

    @Whitelisted
    @Exported(visibility=3)
    public String getPullRequestUrl() {
        return this.pullRequestUrl;
    }
}

