/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import hudson.model.Cause;
import java.io.Serializable;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.kohsuke.stapler.export.Exported;

public final class GitHubPullRequestCommentCause
extends Cause
implements Serializable {
    private final String commentUrl;
    private final String commentAuthor;
    private final String commentBody;

    public GitHubPullRequestCommentCause(String commentUrl, String commentAuthor, String commentBody) {
        this.commentUrl = commentUrl;
        this.commentAuthor = commentAuthor;
        this.commentBody = commentBody;
    }

    @Whitelisted
    public String getShortDescription() {
        return String.format("GitHub pull request comment by %s: %s (%s)", this.commentAuthor, this.commentBody, this.commentUrl);
    }

    @Whitelisted
    @Exported(visibility=3)
    public String getCommentUrl() {
        return this.commentUrl;
    }

    @Whitelisted
    @Exported(visibility=3)
    public String getCommentAuthor() {
        return this.commentAuthor;
    }

    @Whitelisted
    @Exported(visibility=3)
    public String getCommentBody() {
        return this.commentBody;
    }
}

