/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.adobe.jenkins.github_pr_comment_build.GithubHelper;
import com.adobe.jenkins.github_pr_comment_build.TriggerBranchProperty;
import com.cloudbees.jenkins.GitHubRepositoryName;
import hudson.model.Action;
import hudson.model.Cause;
import hudson.model.CauseAction;
import hudson.model.Item;
import hudson.model.Job;
import hudson.security.ACL;
import hudson.security.ACLContext;
import java.util.HashSet;
import java.util.function.BiFunction;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import jenkins.branch.BranchProperty;
import jenkins.branch.MultiBranchProject;
import jenkins.branch.OrganizationFolder;
import jenkins.model.ParameterizedJobMixIn;
import jenkins.scm.api.SCMHead;
import jenkins.scm.api.SCMSource;
import jenkins.scm.api.SCMSourceOwner;
import jenkins.scm.api.SCMSourceOwners;
import net.sf.json.JSONObject;
import org.acegisecurity.Authentication;
import org.jenkinsci.plugins.github.extension.GHEventsSubscriber;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.jenkinsci.plugins.github_branch_source.PullRequestSCMHead;

public abstract class BasePRGHEventSubscriber<T extends TriggerBranchProperty, U>
extends GHEventsSubscriber {
    protected static final Logger LOGGER = Logger.getLogger(BasePRGHEventSubscriber.class.getName());
    protected static final Pattern REPOSITORY_NAME_PATTERN = Pattern.compile("https?://([^/]+)/([^/]+)/([^/]+)");

    protected abstract Class<T> getTriggerClass();

    protected boolean isApplicable(Item item) {
        Job project;
        Object object;
        if (item instanceof Job && (object = (project = (Job)item).getParent()) instanceof SCMSourceOwner) {
            SCMSourceOwner owner = (SCMSourceOwner)object;
            for (SCMSource source : owner.getSCMSources()) {
                if (!(source instanceof GitHubSCMSource)) continue;
                return true;
            }
        }
        return false;
    }

    protected String getRepoUrl(JSONObject json) {
        return json.getJSONObject("repository").getString("html_url");
    }

    protected GitHubRepositoryName getChangedRepository(String repoUrl) {
        Matcher matcher = REPOSITORY_NAME_PATTERN.matcher(repoUrl);
        if (!matcher.matches()) {
            LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
            return null;
        }
        GitHubRepositoryName changedRepository = GitHubRepositoryName.create((String)repoUrl);
        if (changedRepository == null) {
            LOGGER.log(Level.WARNING, "Malformed repository URL {0}", repoUrl);
            return null;
        }
        return changedRepository;
    }

    protected void postStartJob(T branchProp, Job<?, ?> job, U postStartParam) {
    }

    protected void checkAndRunJobs(GitHubRepositoryName changedRepository, int pullRequestId, String author, U postStartParam, BiFunction<Job<?, ?>, T, Cause> getCauseFunction) {
        try (ACLContext aclContext = ACL.as((Authentication)ACL.SYSTEM);){
            boolean jobFound = false;
            HashSet<Job> alreadyTriggeredJobs = new HashSet<Job>();
            for (SCMSourceOwner owner : SCMSourceOwners.all()) {
                for (SCMSource source : owner.getSCMSources()) {
                    GitHubSCMSource gitHubSCMSource;
                    if (!(source instanceof GitHubSCMSource) || !(gitHubSCMSource = (GitHubSCMSource)source).getRepoOwner().equalsIgnoreCase(changedRepository.getUserName()) || !gitHubSCMSource.getRepository().equalsIgnoreCase(changedRepository.getRepositoryName())) continue;
                    OrganizationFolder orgFolder = owner instanceof OrganizationFolder ? (OrganizationFolder)owner : null;
                    for (Job job : owner.getAllJobs()) {
                        PullRequestSCMHead prHead;
                        SCMHead sCMHead;
                        if (orgFolder != null) {
                            if (SCMSource.SourceByItem.findSource((Item)job) != source) continue;
                            LOGGER.log(Level.FINE, "SCM owner is an organization folder and SCM source for job {0} matches", job.getFullName());
                        }
                        if (!((sCMHead = SCMHead.HeadByItem.findHead((Item)job)) instanceof PullRequestSCMHead) || (prHead = (PullRequestSCMHead)sCMHead).getNumber() != pullRequestId) continue;
                        boolean propFound = false;
                        for (BranchProperty prop : ((MultiBranchProject)job.getParent()).getProjectFactory().getBranch(job).getProperties()) {
                            Cause cause;
                            if (!this.getTriggerClass().isAssignableFrom(prop.getClass())) continue;
                            TriggerBranchProperty branchProp = (TriggerBranchProperty)((Object)this.getTriggerClass().cast(prop));
                            propFound = true;
                            if (!GithubHelper.isAuthorized(job, author, branchProp.getMinimumPermissions()) || (cause = getCauseFunction.apply((Job<?, ?>)job, (Job)branchProp)) == null) continue;
                            if (alreadyTriggeredJobs.add(job)) {
                                ParameterizedJobMixIn.scheduleBuild2((Job)job, (int)0, (Action[])new Action[]{new CauseAction(cause)});
                                LOGGER.log(Level.FINE, "Triggered build for {0} due to PR event on {1}:{2}/{3}", new Object[]{job.getFullName(), changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName()});
                                this.postStartJob(branchProp, job, postStartParam);
                                break;
                            }
                            LOGGER.log(Level.FINE, "Skipping already triggered job {0}", new Object[]{job.getFullName()});
                            break;
                        }
                        if (!propFound) {
                            LOGGER.log(Level.FINE, "Job {0} for {1}:{2}/{3} does not have a branch property of type {4}", new Object[]{job.getFullName(), changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName(), this.getTriggerClass().getSimpleName()});
                        }
                        jobFound = true;
                    }
                }
            }
            if (!jobFound) {
                LOGGER.log(Level.FINE, "PR event on {0}:{1}/{2} did not match any job", new Object[]{changedRepository.getHost(), changedRepository.getUserName(), changedRepository.getRepositoryName()});
            }
        }
    }
}

