/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.adobe.jenkins.github_pr_comment_build.BasePRGHEventSubscriber;
import com.adobe.jenkins.github_pr_comment_build.GitHubPullRequestUpdateCause;
import com.adobe.jenkins.github_pr_comment_build.TriggerPRUpdateBranchProperty;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.github.GHEvent;

@Extension
public class PRUpdateGHEventSubscriber
extends BasePRGHEventSubscriber<TriggerPRUpdateBranchProperty, Void> {
    private static final Logger LOGGER = Logger.getLogger(PRUpdateGHEventSubscriber.class.getName());
    private static final String ACTION_EDITED = "edited";

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST, (Enum[])new GHEvent[0]);
    }

    @Override
    protected Class<TriggerPRUpdateBranchProperty> getTriggerClass() {
        return TriggerPRUpdateBranchProperty.class;
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        JSONObject pullRequest = json.getJSONObject("pull_request");
        String pullRequestUrl = pullRequest.getString("html_url");
        int pullRequestId = pullRequest.getInt("number");
        String author = json.getJSONObject("sender").getString("login");
        LOGGER.fine(() -> String.format("PR Update Author: %s", author));
        String action = json.getString("action");
        if (!ACTION_EDITED.equals(action)) {
            LOGGER.log(Level.FINER, "Pull request action is not edited ({0}) for PR {1}, ignoring", new Object[]{action, pullRequestUrl});
            return;
        }
        String repoUrl = this.getRepoUrl(json);
        GitHubRepositoryName changedRepository = this.getChangedRepository(repoUrl);
        if (changedRepository == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Received update on PR {0} for {1}", new Object[]{pullRequestId, repoUrl});
        this.checkAndRunJobs(changedRepository, pullRequestId, author, null, (job, branchProp) -> new GitHubPullRequestUpdateCause(author, pullRequestUrl));
    }
}

