/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.adobe.jenkins.github_pr_comment_build.BasePRGHEventSubscriber;
import com.adobe.jenkins.github_pr_comment_build.GitHubPullRequestReviewCause;
import com.adobe.jenkins.github_pr_comment_build.TriggerPRReviewBranchProperty;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.sf.json.JSONObject;
import org.kohsuke.github.GHEvent;

@Extension
public class PRReviewGHEventSubscriber
extends BasePRGHEventSubscriber<TriggerPRReviewBranchProperty, Void> {
    private static final Logger LOGGER = Logger.getLogger(PRReviewGHEventSubscriber.class.getName());

    @Override
    protected Class<TriggerPRReviewBranchProperty> getTriggerClass() {
        return TriggerPRReviewBranchProperty.class;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.PULL_REQUEST_REVIEW, (Enum[])new GHEvent[0]);
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        JSONObject pullRequest = json.getJSONObject("pull_request");
        String pullRequestUrl = pullRequest.getString("html_url");
        int pullRequestId = pullRequest.getInt("number");
        String author = json.getJSONObject("sender").getString("login");
        LOGGER.fine(() -> String.format("PR Review Author: %s", author));
        String repoUrl = this.getRepoUrl(json);
        GitHubRepositoryName changedRepository = this.getChangedRepository(repoUrl);
        if (changedRepository == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Received review on PR {0} for {1}", new Object[]{pullRequestId, repoUrl});
        this.checkAndRunJobs(changedRepository, pullRequestId, author, null, (job, branchProp) -> new GitHubPullRequestReviewCause(author, pullRequestUrl));
    }
}

