/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.adobe.jenkins.github_pr_comment_build.BasePRGHEventSubscriber;
import com.adobe.jenkins.github_pr_comment_build.GitHubPullRequestCommentCause;
import com.adobe.jenkins.github_pr_comment_build.GithubHelper;
import com.adobe.jenkins.github_pr_comment_build.TriggerPRCommentBranchProperty;
import com.cloudbees.jenkins.GitHubRepositoryName;
import com.google.common.collect.Sets;
import hudson.Extension;
import hudson.model.Job;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import jenkins.scm.api.SCMSource;
import net.sf.json.JSONObject;
import org.kohsuke.github.GHEvent;
import org.kohsuke.github.GHEventPayload;
import org.kohsuke.github.GitHub;
import org.kohsuke.github.ReactionContent;

@Extension
public class IssueCommentGHEventSubscriber
extends BasePRGHEventSubscriber<TriggerPRCommentBranchProperty, String> {
    private static final Logger LOGGER = Logger.getLogger(IssueCommentGHEventSubscriber.class.getName());
    private static final String ACTION_CREATED = "created";
    private static final String ACTION_EDITED = "edited";

    @Override
    protected Class<TriggerPRCommentBranchProperty> getTriggerClass() {
        return TriggerPRCommentBranchProperty.class;
    }

    protected Set<GHEvent> events() {
        return Sets.immutableEnumSet((Enum)GHEvent.ISSUE_COMMENT, (Enum[])new GHEvent[0]);
    }

    private void reactToComment(Job<?, ?> job, String payload) {
        try {
            SCMSource scmSource = SCMSource.SourceByItem.findSource(job);
            GitHub gitHub = GithubHelper.getGitHub(scmSource, job);
            if (gitHub == null) {
                LOGGER.log(Level.WARNING, "Could not react to triggering comment, GitHub connection failed");
                return;
            }
            GHEventPayload.IssueComment event = (GHEventPayload.IssueComment)gitHub.parseEventPayload((Reader)new StringReader(payload), GHEventPayload.IssueComment.class);
            event.getComment().createReaction(ReactionContent.PLUS_ONE);
            LOGGER.log(Level.FINE, "Added plus one reaction to comment {0}", event.getComment().getHtmlUrl());
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, "Could not react to triggering comment", e);
        }
    }

    @Override
    protected void postStartJob(TriggerPRCommentBranchProperty branchProp, Job<?, ?> job, String payload) {
        if (branchProp.getAddReaction()) {
            this.reactToComment(job, payload);
        }
    }

    protected void onEvent(GHEvent event, String payload) {
        JSONObject json = JSONObject.fromObject((Object)payload);
        JSONObject issueJson = json.getJSONObject("issue");
        String issueUrl = issueJson.getString("html_url");
        if (!issueJson.containsKey((Object)"pull_request")) {
            LOGGER.log(Level.FINE, "Issue comment is not for a pull request, ignoring {0}", issueUrl);
            return;
        }
        int pullRequestId = issueJson.getInt("number");
        String commentBody = json.getJSONObject("comment").getString("body");
        String commentAuthor = json.getJSONObject("comment").getJSONObject("user").getString("login");
        String commentUrl = json.getJSONObject("comment").getString("html_url");
        String action = json.getString("action");
        if (!ACTION_CREATED.equals(action) && !ACTION_EDITED.equals(action)) {
            LOGGER.log(Level.FINER, "Issue comment action is not created or edited ({0}) for PR {1}", new Object[]{action, issueUrl});
            return;
        }
        String repoUrl = this.getRepoUrl(json);
        GitHubRepositoryName changedRepository = this.getChangedRepository(repoUrl);
        if (changedRepository == null) {
            return;
        }
        LOGGER.log(Level.FINE, "Received comment on PR {0} for {1}", new Object[]{pullRequestId, repoUrl});
        this.checkAndRunJobs(changedRepository, pullRequestId, commentAuthor, payload, (job, branchProp) -> {
            String expectedCommentBody = branchProp.getCommentBody();
            Pattern pattern = Pattern.compile(expectedCommentBody, 34);
            if (commentBody == null || pattern.matcher(commentBody).matches()) {
                return new GitHubPullRequestCommentCause(commentUrl, commentAuthor, commentBody);
            }
            LOGGER.log(Level.FINER, "Issue comment does not match the trigger build string ({0}) for {1}", new Object[]{expectedCommentBody, job.getFullName()});
            return null;
        });
    }
}

