/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.jenkins.github_pr_comment_build;

import com.cloudbees.plugins.credentials.common.StandardCredentials;
import hudson.model.Job;
import java.io.IOException;
import javax.annotation.Nonnull;
import jenkins.scm.api.SCMSource;
import org.jenkinsci.plugins.github_branch_source.Connector;
import org.jenkinsci.plugins.github_branch_source.GitHubSCMSource;
import org.kohsuke.github.GHPermissionType;
import org.kohsuke.github.GHRepository;
import org.kohsuke.github.GitHub;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GithubHelper {
    private static final Logger LOG = LoggerFactory.getLogger(GithubHelper.class);

    private GithubHelper() {
    }

    public static boolean isAuthorized(Job<?, ?> job, String author, String minimumPermissions) {
        try {
            GHRepository ghRepository = GithubHelper.getGHRepository(job);
            if (ghRepository == null) {
                LOG.debug("Could not retrieve GitHub repository, User {} not authorized", (Object)author);
                return false;
            }
            GHPermissionType authorPermissions = ghRepository.getPermission(author);
            boolean authorized = false;
            switch (GHPermissionType.valueOf((String)minimumPermissions)) {
                case NONE: {
                    authorized = true;
                    break;
                }
                default: {
                    if (authorPermissions != GHPermissionType.WRITE && authorPermissions != GHPermissionType.ADMIN) break;
                    authorized = true;
                    break;
                }
                case ADMIN: {
                    if (authorPermissions != GHPermissionType.ADMIN) break;
                    authorized = true;
                }
            }
            LOG.debug("User {} is {}authorized for job {}", new Object[]{author, authorized ? "" : "not ", job.getFullName()});
            return authorized;
        }
        catch (IOException | IllegalArgumentException e) {
            LOG.debug(String.format("Received an exception while trying to check if user %s is a collaborator for repo of job %s", author, job.getFullName()), (Throwable)e);
            return false;
        }
    }

    public static GitHub getGitHub(SCMSource scmSource, @Nonnull Job<?, ?> job) {
        if (scmSource instanceof GitHubSCMSource) {
            GitHubSCMSource gitHubSource = (GitHubSCMSource)scmSource;
            StandardCredentials credentials = Connector.lookupScanCredentials(job, (String)gitHubSource.getApiUri(), (String)gitHubSource.getCredentialsId(), (String)gitHubSource.getRepoOwner());
            try {
                return Connector.connect((String)gitHubSource.getApiUri(), (StandardCredentials)credentials);
            }
            catch (IOException | IllegalArgumentException e) {
                LOG.debug(String.format("Received an exception while trying to retrieve a GitHub connection for job %s", job.getFullName()), (Throwable)e);
                return null;
            }
        }
        throw new IllegalArgumentException("Job's SCM is not GitHub.");
    }

    private static GHRepository getGHRepository(@Nonnull Job<?, ?> job) throws IOException {
        SCMSource scmSource = SCMSource.SourceByItem.findSource(job);
        GitHub github = GithubHelper.getGitHub(scmSource, job);
        if (github == null) {
            LOG.debug("Could not get GitHub repository, GitHub connection failed");
            return null;
        }
        GitHubSCMSource gitHubSource = (GitHubSCMSource)scmSource;
        return github.getRepository(gitHubSource.getRepoOwner() + "/" + gitHubSource.getRepository());
    }
}

