/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.github.api.mock;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import java.io.Closeable;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.concurrent.atomic.AtomicLong;
import jenkins.plugins.github.api.mock.MockObject;
import jenkins.plugins.github.api.mock.MockOrganization;
import jenkins.plugins.github.api.mock.MockOwner;
import jenkins.plugins.github.api.mock.MockRepository;
import jenkins.plugins.github.api.mock.MockUser;

public class MockGitHub
implements Closeable {
    private AtomicLong nextId = new AtomicLong();
    private Map<String, MockUser> users = new HashMap<String, MockUser>();
    private Map<String, MockOrganization> organizations = new HashMap<String, MockOrganization>();
    private HttpServer server;
    private String url;
    private JsonFactory factory = new JsonFactory();

    public String open() throws IOException {
        this.server = HttpServer.create(new InetSocketAddress(InetAddress.getLoopbackAddress(), 0), 0);
        this.server.createContext("/", new RootHandler(this));
        this.server.createContext("/orgs", new OrgsHandler(this));
        this.server.createContext("/users", new UsersHandler(this));
        this.server.createContext("/repositories", new RepositoriesHandler(this));
        this.server.start();
        InetSocketAddress address = this.server.getAddress();
        this.url = String.format("http://%s:%d", address.getHostString(), address.getPort());
        return this.url;
    }

    @Override
    public void close() {
        this.server.stop(1);
    }

    public String getUrl() {
        return this.url;
    }

    public Map<String, MockUser> getUsers() {
        return this.users;
    }

    public Map<String, MockOrganization> getOrgs() {
        return this.organizations;
    }

    public long nextId() {
        return this.nextId.incrementAndGet();
    }

    public static String tz(long time) {
        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        format.setTimeZone(TimeZone.getTimeZone("UTC"));
        return format.format(new Date(time));
    }

    public MockUser withUser(String login) {
        MockUser result = new MockUser(this, login);
        this.users.put(login, result);
        return result;
    }

    public MockOrganization withOrg(String login) {
        MockOrganization result = new MockOrganization(this, login);
        this.organizations.put(login, result);
        return result;
    }

    public List<MockOwner<?>> owners() {
        ArrayList result = new ArrayList(this.organizations.size() + this.users.size());
        result.addAll(this.users.values());
        result.addAll(this.organizations.values());
        return result;
    }

    private static class RootHandler
    implements HttpHandler {
        private final MockGitHub github;

        public RootHandler(MockGitHub github) {
            this.github = Objects.requireNonNull(github);
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            he.getResponseHeaders().set("Content-Type", "application/json;charset=utf-8");
            he.sendResponseHeaders(200, 0L);
            try (JsonGenerator o = this.github.factory.createGenerator(he.getResponseBody());){
                o.writeStartObject();
                o.writeStringField("current_user_url", this.github.getUrl() + "/user");
                o.writeStringField("current_user_authorizations_html_url", "https://github.com/settings/connections/applications{/client_id}");
                o.writeStringField("authorizations_url", this.github.getUrl() + "/authorizations");
                o.writeStringField("code_search_url", this.github.getUrl() + "/search/code?q={query}{&page,per_page,sort,order}");
                o.writeStringField("commit_search_url", this.github.getUrl() + "/search/commits?q={query}{&page,per_page,sort,order}");
                o.writeStringField("emails_url", this.github.getUrl() + "/user/emails");
                o.writeStringField("emojis_url", this.github.getUrl() + "/emojis");
                o.writeStringField("events_url", this.github.getUrl() + "/events");
                o.writeStringField("feeds_url", this.github.getUrl() + "/feeds");
                o.writeStringField("followers_url", this.github.getUrl() + "/user/followers");
                o.writeStringField("following_url", this.github.getUrl() + "/user/following{/target}");
                o.writeStringField("gists_url", this.github.getUrl() + "/gists{/gist_id}");
                o.writeStringField("hub_url", this.github.getUrl() + "/hub");
                o.writeStringField("issue_search_url", this.github.getUrl() + "/search/issues?q={query}{&page,per_page,sort,order}");
                o.writeStringField("issues_url", this.github.getUrl() + "/issues");
                o.writeStringField("keys_url", this.github.getUrl() + "/user/keys");
                o.writeStringField("notifications_url", this.github.getUrl() + "/notifications");
                o.writeStringField("organization_repositories_url", this.github.getUrl() + "/orgs/{org}/repos{?type,page,per_page,sort}");
                o.writeStringField("organization_url", this.github.getUrl() + "/orgs/{org}");
                o.writeStringField("public_gists_url", this.github.getUrl() + "/gists/public");
                o.writeStringField("rate_limit_url", this.github.getUrl() + "/rate_limit");
                o.writeStringField("repository_url", this.github.getUrl() + "/repos/{owner}/{repo}");
                o.writeStringField("repository_search_url", this.github.getUrl() + "/search/repositories?q={query}{&page,per_page,sort,order}");
                o.writeStringField("current_user_repositories_url", this.github.getUrl() + "/user/repos{?type,page,per_page,sort}");
                o.writeStringField("starred_url", this.github.getUrl() + "/user/starred{/owner}{/repo}");
                o.writeStringField("starred_gists_url", this.github.getUrl() + "/gists/starred");
                o.writeStringField("team_url", this.github.getUrl() + "/teams");
                o.writeStringField("user_url", this.github.getUrl() + "/users/{user}");
                o.writeStringField("user_organizations_url", this.github.getUrl() + "/user/orgs");
                o.writeStringField("user_repositories_url", this.github.getUrl() + "/users/{user}/repos{?type,page,per_page,sort}");
                o.writeStringField("user_search_url", this.github.getUrl() + "/search/users?q={query}{&page,per_page,sort,order}");
                o.writeEndObject();
            }
            he.close();
        }
    }

    private static class OrgsHandler
    implements HttpHandler {
        private final MockGitHub github;

        public OrgsHandler(MockGitHub github) {
            this.github = Objects.requireNonNull(github);
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String path = he.getRequestURI().getPath();
            if (path.endsWith("/")) {
                String orgName = path.substring("/orgs/".length(), path.length() - 1);
                MockOrganization org = this.github.getOrgs().get(orgName);
                if (org != null) {
                    he.getResponseHeaders().set("Content-Type", "application/json;charset=utf-8");
                    he.sendResponseHeaders(200, 0L);
                    try (JsonGenerator o = this.github.factory.createGenerator(he.getResponseBody());){
                        o.writeStartObject();
                        o.writeStringField("login", org.getLogin());
                        o.writeNumberField("id", org.getId());
                        o.writeStringField("url", this.github.getUrl() + "/users/" + org.getLogin());
                        o.writeStringField("repos_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/repos");
                        o.writeStringField("events_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/events");
                        o.writeStringField("hooks_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/hooks");
                        o.writeStringField("issues_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/issues");
                        o.writeStringField("members_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/members{/member}");
                        o.writeStringField("public_members_url", this.github.getUrl() + "/orgs/" + org.getLogin() + "/public_members{/member}");
                        o.writeStringField("avatar_url", org.getAvatarUrl());
                        o.writeStringField("description", org.getDescription());
                        o.writeStringField("name", org.getName());
                        o.writeNullField("company");
                        o.writeStringField("blog", org.getBlog());
                        o.writeStringField("location", org.getLocation());
                        o.writeStringField("email", org.getEmail());
                        o.writeBooleanField("has_organization_projects", true);
                        o.writeBooleanField("has_repository_projects", true);
                        o.writeNumberField("public_repos", org.getPublicRepos());
                        o.writeNumberField("public_gists", 0);
                        o.writeNumberField("followers", org.getFollowers());
                        o.writeNumberField("following", org.getFollowing());
                        o.writeStringField("created_at", MockGitHub.tz(org.getCreated()));
                        o.writeStringField("updated_at", MockGitHub.tz(org.getUpdated()));
                        o.writeStringField("type", org.getType());
                        o.writeEndObject();
                    }
                } else {
                    he.sendResponseHeaders(404, -1L);
                }
            } else {
                String orgName = path.substring("/orgs/".length());
                he.getResponseHeaders().set("Location", "/orgs/" + orgName + "/");
                he.sendResponseHeaders(302, -1L);
            }
            he.close();
        }
    }

    private static class UsersHandler
    implements HttpHandler {
        private final MockGitHub github;

        public UsersHandler(MockGitHub github) {
            this.github = Objects.requireNonNull(github);
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String path = he.getRequestURI().getPath();
            if (path.endsWith("/")) {
                String userName = path.substring("/users/".length(), path.length() - 1);
                MockOwner owner = this.github.getUsers().get(userName);
                if (owner == null) {
                    owner = this.github.getOrgs().get(userName);
                }
                if (owner != null) {
                    he.getResponseHeaders().set("Content-Type", "application/json;charset=utf-8");
                    he.sendResponseHeaders(200, 0L);
                    try (JsonGenerator o = this.github.factory.createGenerator(he.getResponseBody());){
                        MockUser user;
                        o.writeStartObject();
                        o.writeStringField("login", owner.getLogin());
                        o.writeNumberField("id", owner.getId());
                        o.writeStringField("avatar_url", owner.getAvatarUrl());
                        o.writeStringField("gravatar_id", "");
                        o.writeStringField("url", this.github.getUrl() + "/users/" + owner.getLogin());
                        o.writeStringField("html_url", "https://github.com/" + owner.getLogin());
                        o.writeStringField("followers_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/followers");
                        o.writeStringField("following_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/following{/other_user}");
                        o.writeStringField("gists_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/gists{/gist_id}");
                        o.writeStringField("starred_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/starred{/owner}{/repo}");
                        o.writeStringField("subscriptions_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/subscriptions");
                        o.writeStringField("organizations_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/orgs");
                        o.writeStringField("repos_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/repos");
                        o.writeStringField("events_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/events{/privacy}");
                        o.writeStringField("received_events_url", this.github.getUrl() + "/users/" + owner.getLogin() + "/received_events");
                        o.writeStringField("type", owner.getType());
                        if (owner instanceof MockUser) {
                            user = (MockUser)owner;
                            o.writeBooleanField("site_admin", user.isSiteAdmin());
                        } else {
                            o.writeBooleanField("site_admin", false);
                        }
                        o.writeStringField("name", owner.getName());
                        if (owner instanceof MockUser) {
                            user = (MockUser)owner;
                            o.writeStringField("company", user.getCompany());
                        } else {
                            o.writeNullField("company");
                        }
                        o.writeStringField("blog", owner.getBlog());
                        o.writeStringField("location", owner.getLocation());
                        o.writeStringField("email", owner.getEmail());
                        if (owner instanceof MockUser) {
                            user = (MockUser)owner;
                            o.writeBooleanField("hireable", user.isHireable());
                            o.writeStringField("bio", user.getBio());
                        } else {
                            o.writeBooleanField("hireable", false);
                            o.writeNullField("bio");
                        }
                        o.writeNumberField("public_repos", owner.getPublicRepos());
                        o.writeNumberField("public_gists", 0);
                        o.writeNumberField("followers", owner.getFollowers());
                        o.writeNumberField("following", owner.getFollowing());
                        o.writeStringField("created_at", MockGitHub.tz(owner.getCreated()));
                        o.writeStringField("updated_at", MockGitHub.tz(owner.getUpdated()));
                        o.writeEndObject();
                    }
                } else {
                    he.sendResponseHeaders(404, -1L);
                }
            } else {
                String userName = path.substring("/users/".length());
                he.getResponseHeaders().set("Location", "/users/" + userName + "/");
                he.sendResponseHeaders(302, -1L);
            }
            he.close();
        }
    }

    private static class RepositoriesHandler
    implements HttpHandler {
        private final MockGitHub github;

        public RepositoriesHandler(MockGitHub github) {
            this.github = Objects.requireNonNull(github);
        }

        @Override
        public void handle(HttpExchange he) throws IOException {
            String query = he.getRequestURI().getQuery();
            long since = 0L;
            if (query != null) {
                for (String param : query.split("&")) {
                    String[] pair = param.split("=");
                    if (pair.length != 2 || !"since".equals(pair[0])) continue;
                    since = Long.parseLong(pair[1]);
                    break;
                }
            }
            ArrayList<MockRepository> repositories = new ArrayList<MockRepository>();
            for (MockOwner<?> o : this.github.owners()) {
                for (MockRepository r : o.repositories().values()) {
                    if (r.getId() <= since || r.isPrivate()) continue;
                    repositories.add(r);
                }
            }
            repositories.sort(Comparator.comparingLong(MockObject::getId));
            if (repositories.size() > 30) {
                he.getResponseHeaders().set("Link", String.format("<%s/repositories?since=%d>; rel=\"next\", <%s/repositories{?since}>; rel=\"first\"", this.github.getUrl(), ((MockRepository)repositories.get(30)).getId(), this.github.getUrl()));
            } else {
                he.getResponseHeaders().set("Link", String.format("<%s/repositories{?since}>; rel=\"first\"", this.github.getUrl()));
            }
            he.getResponseHeaders().set("Content-Type", "application/json;charset=utf-8");
            he.sendResponseHeaders(200, 0L);
            try (JsonGenerator o = this.github.factory.createGenerator(he.getResponseBody());){
                o.writeStartArray();
                for (MockRepository r : repositories.subList(0, Math.min(30, repositories.size()))) {
                    o.writeStartObject();
                    o.writeNumberField("id", r.getId());
                    o.writeStringField("name", r.getName());
                    o.writeStringField("full_name", r.owner().getLogin() + "/" + r.getName());
                    o.writeFieldName("owner");
                    o.writeStartObject();
                    o.writeStringField("login", r.owner().getLogin());
                    o.writeNumberField("id", r.owner().getId());
                    o.writeStringField("avatar_url", r.owner().getAvatarUrl());
                    o.writeStringField("type", r.owner().getType());
                    o.writeEndObject();
                    o.writeBooleanField("private", r.isPrivate());
                    o.writeStringField("html_url", "https://github.com/" + r.owner().getLogin() + "/" + r.getName());
                    o.writeEndObject();
                }
                o.writeEndArray();
            }
            he.close();
        }
    }
}

