// CHECKSTYLE:OFF

package com.gitee.jenkins.trigger;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code webhook.exist}: {@code Webhook already exists}.
     * 
     * @return
     *     {@code Webhook already exists}
     */
    public static String webhook_exist() {
        return holder.format("webhook.exist");
    }

    /**
     * Key {@code webhook.exist}: {@code Webhook already exists}.
     * 
     * @return
     *     {@code Webhook already exists}
     */
    public static Localizable _webhook_exist() {
        return new Localizable(holder, "webhook.exist");
    }

    /**
     * Key {@code connection.error}: {@code Client error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Client error: {0}}
     */
    public static String connection_error(Object arg0) {
        return holder.format("connection.error", arg0);
    }

    /**
     * Key {@code connection.error}: {@code Client error: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Client error: {0}}
     */
    public static Localizable _connection_error(Object arg0) {
        return new Localizable(holder, "connection.error", arg0);
    }

    /**
     * Key {@code connection.success}: {@code Created webhook: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created webhook: {0}}
     */
    public static String connection_success(Object arg0) {
        return holder.format("connection.success", arg0);
    }

    /**
     * Key {@code connection.success}: {@code Created webhook: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Created webhook: {0}}
     */
    public static Localizable _connection_success(Object arg0) {
        return new Localizable(holder, "connection.success", arg0);
    }

    /**
     * Key {@code Build.Gitee.WebHook}: {@code Build when a change is pushed

     * to Gitee. Gitee webhook URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build when a change is pushed to Gitee. Gitee webhook URL: {0}}
     */
    public static String Build_Gitee_WebHook(Object arg0) {
        return holder.format("Build.Gitee.WebHook", arg0);
    }

    /**
     * Key {@code Build.Gitee.WebHook}: {@code Build when a change is pushed

     * to Gitee. Gitee webhook URL: {0}}.
     * 
     * @param arg0
     *      1st format parameter, {@code {0}}, as {@link String#valueOf(Object)}.
     * @return
     *     {@code Build when a change is pushed to Gitee. Gitee webhook URL: {0}}
     */
    public static Localizable _Build_Gitee_WebHook(Object arg0) {
        return new Localizable(holder, "Build.Gitee.WebHook", arg0);
    }

    /**
     * Key {@code localhost.error}: {@code localhost/127.0.0.1 is not allowed

     * here. Check your root URL settings.}.
     * 
     * @return
     *     {@code localhost/127.0.0.1 is not allowed here. Check your root URL

     *     settings.}
     */
    public static String localhost_error() {
        return holder.format("localhost.error");
    }

    /**
     * Key {@code localhost.error}: {@code localhost/127.0.0.1 is not allowed

     * here. Check your root URL settings.}.
     * 
     * @return
     *     {@code localhost/127.0.0.1 is not allowed here. Check your root URL

     *     settings.}
     */
    public static Localizable _localhost_error() {
        return new Localizable(holder, "localhost.error");
    }

}
