// CHECKSTYLE:OFF

package com.gitee.jenkins.publisher;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code name.required}: {@code Build name required.}.
     * 
     * @return
     *     {@code Build name required.}
     */
    public static String name_required() {
        return holder.format("name.required");
    }

    /**
     * Key {@code name.required}: {@code Build name required.}.
     * 
     * @return
     *     {@code Build name required.}
     */
    public static Localizable _name_required() {
        return new Localizable(holder, "name.required");
    }

    /**
     * Key {@code GiteeMessagePublisher.DisplayName}: {@code Add note with
     * build status on Gitee pull requests}.
     * 
     * @return
     *     {@code Add note with build status on Gitee pull requests}
     */
    public static String GiteeMessagePublisher_DisplayName() {
        return holder.format("GiteeMessagePublisher.DisplayName");
    }

    /**
     * Key {@code GiteeMessagePublisher.DisplayName}: {@code Add note with
     * build status on Gitee pull requests}.
     * 
     * @return
     *     {@code Add note with build status on Gitee pull requests}
     */
    public static Localizable _GiteeMessagePublisher_DisplayName() {
        return new Localizable(holder, "GiteeMessagePublisher.DisplayName");
    }

    /**
     * Key {@code GiteeCreatePullRequestPublisher.DisplayName}: {@code Create
     * Gitee pull request on success}.
     * 
     * @return
     *     {@code Create Gitee pull request on success}
     */
    public static String GiteeCreatePullRequestPublisher_DisplayName() {
        return holder.format("GiteeCreatePullRequestPublisher.DisplayName");
    }

    /**
     * Key {@code GiteeCreatePullRequestPublisher.DisplayName}: {@code Create
     * Gitee pull request on success}.
     * 
     * @return
     *     {@code Create Gitee pull request on success}
     */
    public static Localizable _GiteeCreatePullRequestPublisher_DisplayName() {
        return new Localizable(holder, "GiteeCreatePullRequestPublisher.DisplayName");
    }

    /**
     * Key {@code GiteeCommitStatusPublisher.DisplayName}: {@code Publish
     * build status to Gitee}.
     * 
     * @return
     *     {@code Publish build status to Gitee}
     */
    public static String GiteeCommitStatusPublisher_DisplayName() {
        return holder.format("GiteeCommitStatusPublisher.DisplayName");
    }

    /**
     * Key {@code GiteeCommitStatusPublisher.DisplayName}: {@code Publish
     * build status to Gitee}.
     * 
     * @return
     *     {@code Publish build status to Gitee}
     */
    public static Localizable _GiteeCommitStatusPublisher_DisplayName() {
        return new Localizable(holder, "GiteeCommitStatusPublisher.DisplayName");
    }

    /**
     * Key {@code GiteeAcceptPullRequestPublisher.DisplayName}: {@code Accept
     * Gitee pull request on success}.
     * 
     * @return
     *     {@code Accept Gitee pull request on success}
     */
    public static String GiteeAcceptPullRequestPublisher_DisplayName() {
        return holder.format("GiteeAcceptPullRequestPublisher.DisplayName");
    }

    /**
     * Key {@code GiteeAcceptPullRequestPublisher.DisplayName}: {@code Accept
     * Gitee pull request on success}.
     * 
     * @return
     *     {@code Accept Gitee pull request on success}
     */
    public static Localizable _GiteeAcceptPullRequestPublisher_DisplayName() {
        return new Localizable(holder, "GiteeAcceptPullRequestPublisher.DisplayName");
    }

}
