/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import jakarta.servlet.http.HttpServletRequest;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.eclipse.jgit.api.AddCommand;
import org.eclipse.jgit.api.CommitCommand;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.api.ResetCommand;
import org.eclipse.jgit.api.errors.GitAPIException;
import org.eclipse.jgit.lib.PersonIdent;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.storage.file.FileRepositoryBuilder;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.jenkinsci.plugins.gitserver.HttpGitRepository;
import org.springframework.security.core.Authentication;

public abstract class FileBackedHttpGitRepository
extends HttpGitRepository {
    public final Path workspace;
    private static final Logger LOGGER = Logger.getLogger(FileBackedHttpGitRepository.class.getName());

    protected FileBackedHttpGitRepository(Path workspace) {
        this.workspace = workspace;
        try {
            Files.createDirectory(workspace, new FileAttribute[0]);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
        }
        catch (IOException e) {
            LOGGER.log(Level.WARNING, e, () -> "Cannot create a workspace in " + String.valueOf(workspace));
        }
    }

    protected FileBackedHttpGitRepository(File workspace) {
        this(workspace.toPath());
    }

    @Override
    public Repository openRepository() throws IOException {
        this.checkPullPermission();
        Repository r = ((FileRepositoryBuilder)new FileRepositoryBuilder().setWorkTree(this.workspace.toFile())).build();
        if (!r.getObjectDatabase().exists()) {
            this.createInitialRepository(r);
        }
        return r;
    }

    protected void createInitialRepository(Repository r) throws IOException {
        r.create();
        try {
            Git git = new Git(r);
            AddCommand cmd = git.add();
            cmd.addFilepattern(".");
            cmd.call();
            CommitCommand co = git.commit();
            co.setAuthor("Jenkins", "noreply@jenkins-ci.org");
            co.setMessage("Initial import of the existing contents");
            co.call();
        }
        catch (GitAPIException e) {
            LOGGER.log(Level.WARNING, e, () -> "Initial import of " + String.valueOf(this.workspace) + " into Git repository failed");
        }
    }

    @Override
    public UploadPack createUploadPack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        return new UploadPack(db);
    }

    @Override
    public ReceivePack createReceivePack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        Authentication a = Jenkins.getAuthentication2();
        ReceivePack rp = this.createReceivePack(db);
        rp.setRefLogIdent(new PersonIdent(a.getName(), a.getName() + "@" + context.getRemoteAddr()));
        return rp;
    }

    public ReceivePack createReceivePack(Repository db) {
        this.checkPushPermission();
        ReceivePack rp = new ReceivePack(db);
        rp.setPostReceiveHook((rp1, commands) -> {
            try {
                this.updateWorkspace(rp1.getRepository());
            }
            catch (Exception e) {
                StringWriter sw = new StringWriter();
                e.printStackTrace(new PrintWriter(sw));
                rp1.sendMessage("Failed to update workspace: " + String.valueOf(sw));
            }
        });
        return rp;
    }

    protected void updateWorkspace(Repository repo) throws IOException, GitAPIException {
        ResetCommand cmd = new Git(repo).reset();
        cmd.setMode(ResetCommand.ResetType.HARD);
        cmd.setRef("master");
        cmd.call();
    }

    protected abstract void checkPushPermission();
}

