/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import hudson.Util;
import io.jenkins.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.ServletConfig;
import jakarta.servlet.ServletContext;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.eclipse.jgit.errors.RepositoryNotFoundException;
import org.eclipse.jgit.http.server.GitServlet;
import org.eclipse.jgit.lib.Repository;
import org.eclipse.jgit.transport.ReceivePack;
import org.eclipse.jgit.transport.UploadPack;
import org.eclipse.jgit.transport.resolver.ServiceNotAuthorizedException;
import org.eclipse.jgit.transport.resolver.ServiceNotEnabledException;
import org.jenkinsci.plugins.gitserver.CSRFExclusionImpl;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;

public abstract class HttpGitRepository {
    private GitServlet g;
    private Exception causeOfDeath;
    private static final Logger LOGGER = Logger.getLogger(HttpGitRepository.class.getName());

    protected HttpGitRepository() {
    }

    public abstract Repository openRepository() throws IOException;

    public ReceivePack createReceivePack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        if (Util.isOverridden(HttpGitRepository.class, this.getClass(), (String)"createReceivePack", (Class[])new Class[]{javax.servlet.http.HttpServletRequest.class, Repository.class})) {
            return this.createReceivePack(HttpServletRequestWrapper.fromJakartaHttpServletRequest((HttpServletRequest)context), db);
        }
        throw new AbstractMethodError("Implementing class '" + this.getClass().getName() + "' does not override either overload of the createReceivePack method.");
    }

    @Deprecated(since="134")
    public ReceivePack createReceivePack(javax.servlet.http.HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        if (Util.isOverridden(HttpGitRepository.class, this.getClass(), (String)"createReceivePack", (Class[])new Class[]{HttpServletRequest.class, Repository.class})) {
            return this.createReceivePack(HttpServletRequestWrapper.toJakartaHttpServletRequest((javax.servlet.http.HttpServletRequest)context), db);
        }
        throw new AbstractMethodError("Implementing class '" + this.getClass().getName() + "' does not override either overload of the createReceivePack method.");
    }

    public UploadPack createUploadPack(HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        if (Util.isOverridden(HttpGitRepository.class, this.getClass(), (String)"createUploadPack", (Class[])new Class[]{javax.servlet.http.HttpServletRequest.class, Repository.class})) {
            return this.createUploadPack(HttpServletRequestWrapper.fromJakartaHttpServletRequest((HttpServletRequest)context), db);
        }
        throw new AbstractMethodError("Implementing class '" + this.getClass().getName() + "' does not override either overload of the createUploadPack method.");
    }

    @Deprecated(since="134")
    public UploadPack createUploadPack(javax.servlet.http.HttpServletRequest context, Repository db) throws ServiceNotEnabledException, ServiceNotAuthorizedException {
        if (Util.isOverridden(HttpGitRepository.class, this.getClass(), (String)"createUploadPack", (Class[])new Class[]{HttpServletRequest.class, Repository.class})) {
            return this.createUploadPack(HttpServletRequestWrapper.toJakartaHttpServletRequest((javax.servlet.http.HttpServletRequest)context), db);
        }
        throw new AbstractMethodError("Implementing class '" + this.getClass().getName() + "' does not override either overload of the createUploadPack method.");
    }

    public void checkPullPermission() {
        Jenkins.get().checkPermission(Jenkins.READ);
    }

    protected GitServlet init() {
        GitServlet g = new GitServlet();
        g.setRepositoryResolver((req, name) -> {
            try {
                return this.openRepository();
            }
            catch (IOException e) {
                throw new RepositoryNotFoundException(req.getRequestURI(), (Throwable)e);
            }
        });
        g.setReceivePackFactory(this::createReceivePack);
        g.setUploadPackFactory(this::createUploadPack);
        try {
            g.init(new ServletConfig(){

                public String getServletName() {
                    return "";
                }

                public ServletContext getServletContext() throws IllegalStateException {
                    return Jenkins.get().getServletContext();
                }

                public String getInitParameter(String name) {
                    return null;
                }

                public Enumeration<String> getInitParameterNames() {
                    return Collections.emptyEnumeration();
                }
            });
        }
        catch (ServletException e) {
            LOGGER.log(Level.WARNING, e, () -> "Failed to initialize GitServlet for " + String.valueOf(this));
            this.causeOfDeath = e;
        }
        return g;
    }

    public void doDynamic(StaplerRequest2 req, StaplerResponse2 rsp) throws IOException, ServletException {
        if (this.g == null) {
            this.g = this.init();
        }
        if (this.causeOfDeath != null) {
            throw new ServletException((Throwable)this.causeOfDeath);
        }
        HttpServletRequest realRequest = CSRFExclusionImpl.unwrapRequest((HttpServletRequest)req);
        if (realRequest == null) {
            realRequest = req;
        }
        this.g.service((ServletRequest)realRequest, (ServletResponse)rsp);
    }
}

