/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.gitserver;

import hudson.Extension;
import hudson.security.csrf.CrumbExclusion;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ReadListener;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletInputStream;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletRequestWrapper;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Map;

@Extension
public class CSRFExclusionImpl
extends CrumbExclusion {
    private static final String BOGUS = "bogus";
    static final String ORIGINAL_REQUEST = CSRFExclusionImpl.class.getName() + ".originalRequest";

    public boolean process(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (!"application/x-git-receive-pack-request".equals(request.getHeader("Content-Type"))) {
            return false;
        }
        HttpServletRequestWrapper w = new HttpServletRequestWrapper(request){

            public String getQueryString() {
                return CSRFExclusionImpl.BOGUS;
            }

            public String getParameter(String name) {
                return CSRFExclusionImpl.BOGUS;
            }

            public Map<String, String[]> getParameterMap() {
                return Collections.emptyMap();
            }

            public Enumeration<String> getParameterNames() {
                return Collections.emptyEnumeration();
            }

            public String[] getParameterValues(String name) {
                return new String[]{CSRFExclusionImpl.BOGUS};
            }

            public String getMethod() {
                return CSRFExclusionImpl.BOGUS.toUpperCase(Locale.ROOT);
            }

            public ServletInputStream getInputStream() {
                return new ServletInputStream(){

                    public boolean isFinished() {
                        return false;
                    }

                    public boolean isReady() {
                        return true;
                    }

                    public int read() {
                        return -1;
                    }

                    public void setReadListener(ReadListener readListener) {
                    }
                };
            }
        };
        w.setAttribute(ORIGINAL_REQUEST, (Object)request);
        chain.doFilter((ServletRequest)w, (ServletResponse)response);
        return true;
    }

    public static HttpServletRequest unwrapRequest(HttpServletRequest req) {
        return (HttpServletRequest)req.getAttribute(ORIGINAL_REQUEST);
    }
}

