/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.figlet_buildstep;

import com.github.lalyos.jfiglet.FigletFont;
import com.google.inject.Inject;
import hudson.Extension;
import hudson.model.TaskListener;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.workflow.steps.AbstractStepDescriptorImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractStepImpl;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.StepContextParameter;
import org.kohsuke.stapler.DataBoundConstructor;

public class FigletStep
extends AbstractStepImpl {
    public final String message;

    @DataBoundConstructor
    public FigletStep(String message) {
        this.message = message;
    }

    @Extension
    public static final class DescriptorImpl
    extends AbstractStepDescriptorImpl {
        public DescriptorImpl() {
            super(FigletStepExecution.class);
        }

        public String getFunctionName() {
            return "figlet";
        }

        public String getDisplayName() {
            return "Figlet";
        }
    }

    public static class FigletStepExecution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private static final long serialVersionUID = 1L;
        @Inject
        private transient FigletStep step;
        @StepContextParameter
        private transient TaskListener listener;

        protected Void run() throws Exception {
            if (StringUtils.isNotEmpty((String)this.step.message)) {
                for (String line : this.step.message.split("\r?\n")) {
                    this.listener.getLogger().println(FigletFont.convertOneLine((String)line));
                }
            }
            return null;
        }
    }
}

