/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.figlet_buildstep;

import com.github.lalyos.jfiglet.FigletFont;
import hudson.Extension;
import hudson.Launcher;
import hudson.model.AbstractBuild;
import hudson.model.AbstractProject;
import hudson.model.BuildListener;
import hudson.tasks.BuildStepDescriptor;
import hudson.tasks.Builder;
import hudson.util.FormValidation;
import jakarta.servlet.ServletException;
import java.io.IOException;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.plugins.figlet_buildstep.Messages;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

public class FigletBuilder
extends Builder {
    private final String message;

    @DataBoundConstructor
    public FigletBuilder(String message) {
        this.message = message;
    }

    public String getMessage() {
        return this.message;
    }

    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException {
        if (StringUtils.isNotEmpty((String)this.message)) {
            for (String line : this.message.split("\r?\n")) {
                listener.getLogger().println(FigletFont.convertOneLine((String)line));
            }
        }
        return true;
    }

    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    @Extension
    public static final class DescriptorImpl
    extends BuildStepDescriptor<Builder> {
        public DescriptorImpl() {
            this.load();
        }

        public FormValidation doCheckMessage(@QueryParameter String value) throws IOException, ServletException {
            if (value.length() == 0) {
                return FormValidation.error((String)Messages.setMessageError());
            }
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            return true;
        }

        public String getDisplayName() {
            return Messages.displayName();
        }
    }
}

