// CHECKSTYLE:OFF

package org.jenkinsci.plugins.figlet_buildstep;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code displayName}: {@code Figlet Builder}.
     * 
     * @return
     *     {@code Figlet Builder}
     */
    public static String displayName() {
        return holder.format("displayName");
    }

    /**
     * Key {@code displayName}: {@code Figlet Builder}.
     * 
     * @return
     *     {@code Figlet Builder}
     */
    public static Localizable _displayName() {
        return new Localizable(holder, "displayName");
    }

    /**
     * Key {@code setMessageError}: {@code Please set a message}.
     * 
     * @return
     *     {@code Please set a message}
     */
    public static String setMessageError() {
        return holder.format("setMessageError");
    }

    /**
     * Key {@code setMessageError}: {@code Please set a message}.
     * 
     * @return
     *     {@code Please set a message}
     */
    public static Localizable _setMessageError() {
        return new Localizable(holder, "setMessageError");
    }

}
