package org.jenkinsci.plugins.figlet_buildstep;

import hudson.Launcher;
import hudson.Extension;
import hudson.util.FormValidation;
import hudson.model.AbstractBuild;
import hudson.model.BuildListener;
import hudson.model.AbstractProject;
import hudson.tasks.Builder;
import hudson.tasks.BuildStepDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;

import jakarta.servlet.ServletException;
import java.io.IOException;

import com.github.lalyos.jfiglet.FigletFont;
import org.apache.commons.lang.StringUtils;


public class FigletBuilder extends Builder {

    private final String message;

    @DataBoundConstructor
    public FigletBuilder(String message) {
        this.message = message;
    }

    /**
     * We'll use this from the <code>config.jelly</code>.
     */
    public String getMessage() {
        return message;
    }

    @Override
    public boolean perform(AbstractBuild build, Launcher launcher, BuildListener listener) throws IOException {
        if(StringUtils.isNotEmpty(message)) {
            for(String line : message.split("\r?\n")) {
                listener.getLogger().println(FigletFont.convertOneLine(line));
            }
        }
        return true;
    }

    // Overridden for better type safety.
    // If your plugin doesn't really define any property on Descriptor,
    // you don't have to do this.
    @Override
    public DescriptorImpl getDescriptor() {
        return (DescriptorImpl)super.getDescriptor();
    }

    /**
     * Descriptor for {@link FigletBuilder}. Used as a singleton.
     * The class is marked as public so that it can be accessed from views.
     *
     */
    @Extension // This indicates to Jenkins that this is an implementation of an extension point.
    public static final class DescriptorImpl extends BuildStepDescriptor<Builder> {

        /**
         * In order to load the persisted global configuration, you have to
         * call load() in the constructor.
         */
        public DescriptorImpl() {
            load();
        }

        /**
         * Performs on-the-fly validation of the form field 'message'.
         *
         * @param value
         *      This parameter receives the value that the user has typed.
         * @return
         *      Indicates the outcome of the validation. This is sent to the browser.
         */
        public FormValidation doCheckMessage(@QueryParameter String value)
                throws IOException, ServletException {
            if (value.length() == 0)
                return FormValidation.error(Messages.setMessageError());
            return FormValidation.ok();
        }

        public boolean isApplicable(Class<? extends AbstractProject> aClass) {
            // Indicates that this builder can be used with all kinds of project types
            return true;
        }

        /**
         * This human-readable name is used in the configuration screen.
         */
        public String getDisplayName() {
            return Messages.displayName();
        }
    }
}
