/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.Items;
import hudson.model.Job;
import hudson.model.Run;
import hudson.tasks.test.AbstractTestResultAction;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class TestResultColumn
extends ListViewColumn {
    private int testResultFormat = 0;

    @DataBoundConstructor
    public TestResultColumn(int testResultFormat) {
        this.testResultFormat = testResultFormat;
    }

    public TestResultColumn() {
        this(0);
    }

    public int getTestResultFormat() {
        return this.testResultFormat;
    }

    public AbstractTestResultAction<?> getTestResultAction(Job<?, ?> job) {
        Run b = job.getLastCompletedBuild();
        return b != null ? (AbstractTestResultAction)b.getAction(AbstractTestResultAction.class) : null;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public DescriptorImpl() {
            Items.XSTREAM2.addCompatibilityAlias("hudson.views.TestResultColumn", TestResultColumn.class);
        }

        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.TestResultColumn_DisplayName();
        }

        public String getHelpFile() {
            return "/plugin/extra-columns/help-testresult-column.html";
        }
    }
}

