/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.XmlFile;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.Date;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.plugins.extracolumns.Messages;
import org.apache.commons.lang.time.FastDateFormat;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastJobConfigurationModificationColumn
extends ListViewColumn {
    private static final Logger LOGGER = Logger.getLogger(LastJobConfigurationModificationColumn.class.getName());

    @DataBoundConstructor
    public LastJobConfigurationModificationColumn() {
    }

    public String getInfo(Job<?, ?> job) {
        XmlFile config = job.getConfigFile();
        if (config == null || !config.exists()) {
            return "N/A";
        }
        try {
            long lm = config.getFile().lastModified();
            return FastDateFormat.getInstance((String)"yyyy-MM-dd HH:mm:ss").format(new Date(lm));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Cannot read last modification date of configuration for job '" + job.getName() + "'.", e);
            return "N/A";
        }
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.LastJobConfigurationModificationColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

