/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractBuild;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.Run;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.model.Jenkins;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class LastBuildNodeColumn
extends ListViewColumn {
    @DataBoundConstructor
    public LastBuildNodeColumn() {
    }

    public String getLastBuildNode(Job<?, ?> job) {
        Run lastBuild = job.getLastBuild();
        if (lastBuild instanceof AbstractBuild) {
            Node builtOn = ((AbstractBuild)lastBuild).getBuiltOn();
            if (builtOn instanceof Jenkins) {
                return "master";
            }
            if (builtOn != null) {
                return builtOn.getDisplayName();
            }
        }
        return null;
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.LastBuildNodeColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

