/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractProject;
import hudson.model.Job;
import hudson.model.Label;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.logging.Logger;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class SlaveOrLabelColumn
extends ListViewColumn {
    private static final Logger LOGGER = Logger.getLogger(SlaveOrLabelColumn.class.getName());

    @DataBoundConstructor
    public SlaveOrLabelColumn() {
    }

    public Label getLabel(Job<?, ?> job) {
        if (!(job instanceof AbstractProject)) {
            LOGGER.finest("Not an instance of " + AbstractProject.class.getCanonicalName() + ". Cannot get info.");
            return null;
        }
        AbstractProject project = (AbstractProject)AbstractProject.class.cast(job);
        return project.getAssignedLabel();
    }

    public String getDescription(Label label) {
        if (label == null) {
            return "";
        }
        String desc = label.getDescription();
        return desc == null || desc.length() < 1 ? "" : "(" + desc + ")";
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.SlaveOrLabelColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

