/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.Util;
import hudson.model.Job;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import java.util.GregorianCalendar;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class BuildDurationColumn
extends ListViewColumn {
    private int buildDurationType = 0;

    @DataBoundConstructor
    public BuildDurationColumn(int buildDurationType) {
        this.buildDurationType = buildDurationType;
    }

    public BuildDurationColumn() {
        this(0);
    }

    public int getBuildDurationType() {
        return this.buildDurationType;
    }

    public long getSortDataBuildRunningSince(Job<?, ?> job) {
        return new GregorianCalendar().getTimeInMillis() - job.getLastBuild().getTimeInMillis();
    }

    public String getAverageBuildDurationString(Job<?, ?> job) {
        return Util.getTimeSpanString((long)job.getLastBuild().getEstimatedDuration());
    }

    public String getAverageBuildDurationMinsString(Job<?, ?> job) {
        return String.valueOf(job.getLastBuild().getEstimatedDuration() / 1000L / 60L);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public boolean shownByDefault() {
            return false;
        }

        public String getDisplayName() {
            return Messages.BuildDurationColumn_DisplayName();
        }
    }
}

