/*
 * Decompiled with CFR 0.152.
 */
package jenkins.plugins.extracolumns;

import hudson.Extension;
import hudson.model.AbstractItem;
import hudson.views.ListViewColumn;
import hudson.views.ListViewColumnDescriptor;
import jenkins.plugins.extracolumns.Messages;
import org.kohsuke.stapler.DataBoundConstructor;

public class WorkspaceColumn
extends ListViewColumn {
    @DataBoundConstructor
    public WorkspaceColumn() {
    }

    public boolean isPipelineJob(AbstractItem item) {
        String simpleName = item.getClass().getSimpleName();
        return "WorkflowJob".equals(simpleName);
    }

    public boolean showWorkspace(AbstractItem item) {
        String simpleName = item.getClass().getSimpleName();
        return !"Folder".equals(simpleName) && !"MatrixProject".equals(simpleName) && !"WorkflowMultiBranchProject".equals(simpleName);
    }

    @Extension
    public static class DescriptorImpl
    extends ListViewColumnDescriptor {
        public String getDisplayName() {
            return Messages.WorkspaceColumn_DisplayName();
        }

        public boolean shownByDefault() {
            return false;
        }
    }
}

