// CHECKSTYLE:OFF

package org.jenkinsci.plugins.externalmonitorjob;

import org.jvnet.localizer.Localizable;
import org.jvnet.localizer.ResourceBundleHolder;
import org.kohsuke.accmod.Restricted;


/**
 * Generated localization support class.
 * 
 */
@SuppressWarnings({
    "",
    "PMD",
    "all"
})
@Restricted(org.kohsuke.accmod.restrictions.NoExternalUse.class)
public class Messages {

    /**
     * The resource bundle reference
     * 
     */
    private final static ResourceBundleHolder holder = ResourceBundleHolder.get(Messages.class);

    /**
     * Key {@code ExternalJob.displayName}: {@code External Job}.
     * 
     * @return
     *     {@code External Job}
     */
    public static String ExternalJob_displayName() {
        return holder.format("ExternalJob.displayName");
    }

    /**
     * Key {@code ExternalJob.displayName}: {@code External Job}.
     * 
     * @return
     *     {@code External Job}
     */
    public static Localizable _ExternalJob_displayName() {
        return new Localizable(holder, "ExternalJob.displayName");
    }

    /**
     * Key {@code ExternalJob.Description}: {@code This type of job allows
     * you to record the execution of a process run outside Jenkins, even on
     * a remote machine. This is designed so that you can use Jenkins as a
     * dashboard of your existing automation system.}.
     * 
     * @return
     *     {@code This type of job allows you to record the execution of a
     *     process run outside Jenkins, even on a remote machine. This is
     *     designed so that you can use Jenkins as a dashboard of your existing
     *     automation system.}
     */
    public static String ExternalJob_Description() {
        return holder.format("ExternalJob.Description");
    }

    /**
     * Key {@code ExternalJob.Description}: {@code This type of job allows
     * you to record the execution of a process run outside Jenkins, even on
     * a remote machine. This is designed so that you can use Jenkins as a
     * dashboard of your existing automation system.}.
     * 
     * @return
     *     {@code This type of job allows you to record the execution of a
     *     process run outside Jenkins, even on a remote machine. This is
     *     designed so that you can use Jenkins as a dashboard of your existing
     *     automation system.}
     */
    public static Localizable _ExternalJob_Description() {
        return new Localizable(holder, "ExternalJob.Description");
    }

}
