/*
 * Decompiled with CFR 0.152.
 */
package hudson.model;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Proc;
import hudson.model.BuildListener;
import hudson.model.ExternalJob;
import hudson.model.Job;
import hudson.model.Result;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.DecodingStream;
import hudson.util.DualOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.Map;
import java.util.Scanner;
import java.util.zip.GZIPInputStream;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class ExternalRun
extends Run<ExternalJob, ExternalRun> {
    public static final String ENABLE_DTD_PROPERTY_NAME = String.valueOf(ExternalRun.class) + ".supportDTD";

    ExternalRun(ExternalJob owner, File runDir) throws IOException {
        super((Job)owner, runDir);
    }

    ExternalRun(ExternalJob project) throws IOException {
        super((Job)project);
    }

    public void run(final String[] cmd) {
        this.execute(new Run.RunExecution(this){
            final /* synthetic */ ExternalRun this$0;
            {
                this.this$0 = this$0;
                super((Run)this$0);
            }

            public Result run(BuildListener listener) throws Exception {
                Proc.LocalProc proc = new Proc.LocalProc(cmd, (Map)this.this$0.getEnvironment((TaskListener)listener), System.in, (OutputStream)new DualOutputStream((OutputStream)System.out, (OutputStream)listener.getLogger()));
                return proc.join() == 0 ? Result.SUCCESS : Result.FAILURE;
            }

            public void post(BuildListener listener) {
            }

            public void cleanUp(BuildListener listener) {
            }
        });
    }

    private void setCharset(String c) {
        this.charset = c;
    }

    private Result parseResult(String text) {
        Scanner sc = new Scanner(text);
        Result result = sc.hasNextInt() ? (sc.nextInt() == 0 ? Result.SUCCESS : Result.FAILURE) : Result.fromString((String)text);
        return result;
    }

    public void acceptRemoteSubmission(final Reader in) throws IOException {
        final long[] duration = new long[1];
        this.execute(new Run.RunExecution(this){
            final /* synthetic */ ExternalRun this$0;
            {
                this.this$0 = this$0;
                super((Run)this$0);
            }

            private String elementText(XMLStreamReader r) throws XMLStreamException {
                int type;
                StringBuilder buf = new StringBuilder();
                while ((type = r.next()) == 4 || type == 12) {
                    buf.append(r.getTextCharacters(), r.getTextStart(), r.getTextLength());
                }
                return buf.toString();
            }

            @SuppressFBWarnings(value={"OS_OPEN_STREAM", "DM_DEFAULT_ENCODING"}, justification="Logger will be handled upstream")
            public Result run(BuildListener listener) throws Exception {
                PrintStream logger = new PrintStream((OutputStream)new DecodingStream((OutputStream)listener.getLogger()));
                XMLInputFactory xif = XMLInputFactory.newInstance();
                xif.setProperty("javax.xml.stream.supportDTD", Boolean.parseBoolean(System.getProperty(ENABLE_DTD_PROPERTY_NAME)));
                XMLStreamReader p = xif.createXMLStreamReader(in);
                p.nextTag();
                p.nextTag();
                this.this$0.setCharset(p.getAttributeValue(null, "content-encoding"));
                while (p.next() != 2) {
                    int type = p.getEventType();
                    if (type != 4 && type != 12) continue;
                    logger.print(p.getText());
                }
                p.nextTag();
                Result r = this.this$0.parseResult(this.elementText(p));
                do {
                    p.nextTag();
                    if (p.getEventType() != 1) continue;
                    if (p.getLocalName().equals("duration")) {
                        duration[0] = Long.parseLong(this.elementText(p));
                        continue;
                    }
                    if (p.getLocalName().equals("displayName")) {
                        this.this$0.setDisplayName(p.getElementText());
                        continue;
                    }
                    if (!p.getLocalName().equals("description")) continue;
                    this.this$0.setDescription(p.getElementText());
                } while (p.getEventType() != 2 || !p.getLocalName().equals("run"));
                return r;
            }

            public void post(BuildListener listener) {
            }

            public void cleanUp(BuildListener listener) {
            }
        });
        if (duration[0] != 0L) {
            this.duration = duration[0];
            this.save();
        }
    }

    public void acceptRemoteSubmission(final int result, long duration, final InputStream stream) throws IOException {
        this.execute(new Run.RunExecution(this){
            final /* synthetic */ ExternalRun this$0;
            {
                this.this$0 = this$0;
                super((Run)this$0);
            }

            @SuppressFBWarnings(value={"OS_OPEN_STREAM", "DM_DEFAULT_ENCODING"}, justification="Logger will be handled upstream")
            public Result run(BuildListener listener) throws Exception {
                int length;
                PrintStream logger = new PrintStream(listener.getLogger());
                int sChunk = 8192;
                GZIPInputStream zipin = new GZIPInputStream(stream);
                byte[] buffer = new byte[8192];
                while ((length = zipin.read(buffer, 0, 8192)) != -1) {
                    logger.write(buffer, 0, length);
                }
                Result r = result == 0 ? Result.SUCCESS : Result.FAILURE;
                return r;
            }

            public void post(BuildListener listener) {
            }

            public void cleanUp(BuildListener listener) {
            }
        });
        this.duration = duration;
        this.save();
    }

    public void acceptRemoteSubmission(final int result, long duration, final String log) throws IOException {
        this.execute(new Run.RunExecution(this){
            final /* synthetic */ ExternalRun this$0;
            {
                this.this$0 = this$0;
                super((Run)this$0);
            }

            @SuppressFBWarnings(value={"OS_OPEN_STREAM", "DM_DEFAULT_ENCODING"}, justification="Logger will be handled upstream")
            public Result run(BuildListener listener) throws Exception {
                PrintStream logger = new PrintStream(listener.getLogger());
                logger.print(log);
                Result r = result == 0 ? Result.SUCCESS : Result.FAILURE;
                return r;
            }

            public void post(BuildListener listener) {
            }

            public void cleanUp(BuildListener listener) {
            }
        });
        this.duration = duration;
        this.save();
    }
}

