/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import com.google.common.collect.Maps;
import hudson.model.AbstractBuild;
import hudson.model.Action;
import java.io.File;
import java.io.ObjectStreamException;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.map.UnmodifiableMap;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.EnvInjectPlugin;
import org.jenkinsci.plugins.envinject.EnvInjectVarList;
import org.jenkinsci.plugins.envinjectapi.util.EnvInjectVarsIO;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;
import org.kohsuke.stapler.StaplerProxy;

@Deprecated
public class EnvInjectAction
implements Action,
StaplerProxy {
    @Deprecated
    @Restricted(value={NoExternalUse.class})
    public static final String URL_NAME = "injectedEnvVars";
    private transient Map<String, String> envMap;
    private AbstractBuild build;
    private transient Map<String, String> resultVariables;
    private transient File rootDir;

    public EnvInjectAction(AbstractBuild build, Map<String, String> envMap) {
        this.build = build;
        this.envMap = envMap;
    }

    public void overrideAll(Map<String, String> all) {
        this.envMap.putAll(all);
    }

    public Map<String, String> getEnvMap() {
        return UnmodifiableMap.decorate(this.envMap);
    }

    public String getIconFileName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.build)) {
            return null;
        }
        return "document-properties.png";
    }

    public String getDisplayName() {
        return "Environment Variables";
    }

    public String getUrlName() {
        if (!EnvInjectPlugin.canViewInjectedVars(this.build)) {
            return null;
        }
        return URL_NAME;
    }

    protected AbstractBuild getBuild() {
        return this.build;
    }

    public Object getTarget() {
        final Set sensitiveVariables = this.build.getSensitiveBuildVariables();
        if (!EnvInjectPlugin.canViewInjectedVars(this.build)) {
            return EnvInjectVarList.HIDDEN;
        }
        return new EnvInjectVarList(Maps.transformEntries(this.envMap, (Maps.EntryTransformer)new Maps.EntryTransformer<String, String, String>(){

            public String transformEntry(String key, String value) {
                return sensitiveVariables.contains(key) ? "[*******]" : value;
            }
        }));
    }

    private Object writeReplace() throws ObjectStreamException {
        if (this.envMap == null) {
            return this;
        }
        if (this.envMap.size() == 0) {
            return this;
        }
        if (this.build == null) {
            return this;
        }
        try {
            if (this.rootDir == null) {
                EnvInjectVarsIO.saveEnvironment((File)this.build.getRootDir(), this.envMap);
                return this;
            }
            EnvInjectVarsIO.saveEnvironment((File)this.rootDir, this.envMap);
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return this;
    }

    protected Object readResolve() throws ObjectStreamException {
        if (this.resultVariables != null) {
            this.envMap = this.resultVariables;
            return this;
        }
        Map resultMap = null;
        try {
            if (this.build != null) {
                resultMap = EnvInjectVarsIO.getEnvironment((File)this.build.getRootDir());
            } else if (this.rootDir != null) {
                resultMap = EnvInjectVarsIO.getEnvironment((File)this.rootDir);
            }
            if (resultMap != null) {
                this.envMap = resultMap;
            }
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return this;
    }
}

