/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.Nullable;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Util;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.plugins.envinject.service.PropertiesGetter;
import org.jenkinsci.plugins.envinject.service.PropertiesLoader;
import org.kohsuke.stapler.DataBoundConstructor;

public class EnvInjectInfo
implements Serializable {
    @CheckForNull
    protected String propertiesFilePath;
    @CheckForNull
    protected String propertiesContent;
    @Deprecated
    @CheckForNull
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Deprecated")
    private transient Map<String, String> propertiesContentMap;
    @Deprecated
    @CheckForNull
    @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Deprecated")
    protected transient boolean populateTriggerCause;

    @DataBoundConstructor
    public EnvInjectInfo(String propertiesFilePath, String propertiesContent) {
        this.propertiesFilePath = Util.fixEmpty((String)propertiesFilePath);
        this.propertiesContent = this.fixCrLf(Util.fixEmpty((String)propertiesContent));
    }

    @CheckForNull
    public String getPropertiesFilePath() {
        return this.propertiesFilePath;
    }

    @CheckForNull
    public String getPropertiesContent() {
        if (this.propertiesContentMap != null && this.propertiesContentMap.size() != 0) {
            PropertiesGetter propertiesGetter = new PropertiesGetter();
            return propertiesGetter.getPropertiesContentFromMapObject(this.propertiesContentMap);
        }
        return this.propertiesContent;
    }

    @CheckForNull
    public Map<String, String> getPropertiesContentMap(@NonNull Map<String, String> currentEnvVars) {
        if (this.propertiesContentMap != null && this.propertiesContentMap.size() != 0) {
            return this.propertiesContentMap;
        }
        if (this.propertiesContent == null) {
            return null;
        }
        if (this.propertiesContent.trim().length() == 0) {
            return null;
        }
        Map<String, String> contentMap = new HashMap<String, String>();
        PropertiesLoader loader = new PropertiesLoader();
        try {
            contentMap = loader.getVarsFromPropertiesContent(this.propertiesContent, currentEnvVars);
        }
        catch (EnvInjectException e) {
            e.printStackTrace();
        }
        return contentMap;
    }

    @Nullable
    protected String fixCrLf(@CheckForNull String s) {
        int idx;
        if (s == null) {
            return null;
        }
        while ((idx = ((String)s).indexOf("\r\n")) != -1) {
            s = ((String)s).substring(0, idx) + ((String)s).substring(idx + 1);
        }
        return s;
    }
}

