/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Util;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.io.StringReader;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Properties;
import org.jenkinsci.lib.envinject.EnvInjectException;

public class PropertiesLoader
implements Serializable {
    @NonNull
    public Map<String, String> getVarsFromPropertiesFile(@NonNull File propertiesFile, @NonNull Map<String, String> currentEnvVars) throws EnvInjectException {
        if (propertiesFile == null) {
            throw new NullPointerException("The properties file object must be set.");
        }
        if (!propertiesFile.exists()) {
            throw new IllegalArgumentException("The properties file object must be exist.");
        }
        try {
            String fileContent = Util.loadFile((File)propertiesFile);
            return this.getVars(fileContent, currentEnvVars);
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", (Throwable)ioe);
        }
    }

    @NonNull
    public Map<String, String> getVarsFromPropertiesContent(@NonNull String content, @NonNull Map<String, String> currentEnvVars) throws EnvInjectException {
        if (content == null) {
            throw new NullPointerException("A properties content must be set.");
        }
        if (content.trim().length() == 0) {
            throw new IllegalArgumentException("A properties content must be not empty.");
        }
        return this.getVars(content, currentEnvVars);
    }

    @NonNull
    private Map<String, String> getVars(@NonNull String content, @NonNull Map<String, String> currentEnvVars) throws EnvInjectException {
        String escapedContent = content;
        escapedContent = escapedContent.replaceAll("(?<![\\\\])\\\\(?![n:*?\"<>\\\\/])(?![\\\\])(?![\n])", "\\\\\\\\");
        escapedContent = escapedContent.replaceAll("(?m)^([^=]+=)(\\\\\\\\)(?![:*?\"<>\\\\/])", "$1\\\\\\\\\\\\\\\\");
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Properties properties = new Properties();
        try (StringReader stringReader = new StringReader(escapedContent);){
            properties.load(stringReader);
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Problem occurs on loading content", (Throwable)ioe);
        }
        for (Map.Entry<Object, Object> entry : properties.entrySet()) {
            result.put(this.processElement(entry.getKey(), currentEnvVars), this.processElement(entry.getValue(), currentEnvVars));
        }
        return result;
    }

    @CheckForNull
    private String processElement(@CheckForNull Object prop, @NonNull Map<String, String> currentEnvVars) {
        String macroProcessedElement = Util.replaceMacro((String)String.valueOf(prop), currentEnvVars);
        if (macroProcessedElement == null) {
            return null;
        }
        return macroProcessedElement.trim();
    }
}

