/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.util;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.matrix.MatrixRun;
import hudson.model.AbstractBuild;
import hudson.model.Environment;
import hudson.model.EnvironmentContributor;
import hudson.model.EnvironmentList;
import hudson.model.Executor;
import hudson.model.JDK;
import hudson.model.Job;
import hudson.model.Node;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Run;
import hudson.model.TaskListener;
import hudson.util.LogTaskListener;
import java.io.IOException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.EnvInjectJobProperty;
import org.jenkinsci.plugins.envinject.EnvInjectJobPropertyInfo;
import org.jenkinsci.plugins.envinject.EnvInjectPluginAction;
import org.jenkinsci.plugins.envinject.service.BuildCauseRetriever;
import org.jenkinsci.plugins.envinject.service.EnvInjectVariableGetter;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class RunHelper {
    private static final Logger LOGGER = Logger.getLogger(RunHelper.class.getName());

    public static Set<String> getSensitiveBuildVariables(@NonNull Run<?, ?> run) {
        if (run instanceof AbstractBuild) {
            return ((AbstractBuild)run).getSensitiveBuildVariables();
        }
        HashSet<String> s = new HashSet<String>();
        ParametersAction parameters = (ParametersAction)run.getAction(ParametersAction.class);
        if (parameters != null) {
            for (ParameterValue p : parameters) {
                if (!p.isSensitive()) continue;
                s.add(p.getName());
            }
        }
        return s;
    }

    public static void getBuildVariables(@NonNull Run<?, ?> run, EnvVars result) {
        ParametersAction parameters;
        if (run instanceof AbstractBuild) {
            Map buildVariables = ((AbstractBuild)run).getBuildVariables();
            result.putAll(buildVariables);
        }
        if ((parameters = (ParametersAction)run.getAction(ParametersAction.class)) != null) {
            for (ParameterValue p : parameters) {
                p.buildEnvironment(run, result);
            }
        }
    }

    public static void getJDKVariables(@NonNull Run<?, ?> run, TaskListener logger, EnvVars result) throws IOException, InterruptedException {
        AbstractBuild b;
        JDK jdk;
        if (run instanceof AbstractBuild && (jdk = (b = (AbstractBuild)run).getProject().getJDK()) != null) {
            Node node = b.getBuiltOn();
            if (node != null) {
                jdk = jdk.forNode(node, logger);
            }
            jdk.buildEnvVars(result);
        }
    }

    public static Map<String, String> getBuildVariables(@NonNull Run<?, ?> run, @NonNull EnvInjectLogger logger) throws EnvInjectException {
        String rootUrl;
        EnvVars result = new EnvVars();
        result.putAll((Map)run.getCharacteristicEnvVars());
        try {
            EnvVars envVars = new EnvVars();
            for (EnvironmentContributor ec : EnvironmentContributor.all()) {
                ec.buildEnvironmentFor(run, envVars, (TaskListener)new LogTaskListener(LOGGER, Level.ALL));
                result.putAll((Map)envVars);
            }
            RunHelper.getJDKVariables(run, logger.getListener(), result);
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException((Throwable)ie);
        }
        Executor e = run.getExecutor();
        if (e != null) {
            result.put("EXECUTOR_NUMBER", String.valueOf(e.getNumber()));
        }
        if ((rootUrl = Jenkins.getActiveInstance().getRootUrl()) != null) {
            result.put("BUILD_URL", rootUrl + run.getUrl());
            result.put("JOB_URL", rootUrl + run.getParent().getUrl());
        }
        RunHelper.getBuildVariables(run, result);
        Map<String, String> triggerVariable = new BuildCauseRetriever().getTriggeredCause(run);
        result.putAll(triggerVariable);
        return result;
    }

    @CheckForNull
    public static EnvInjectJobProperty getEnvInjectJobProperty(@NonNull Run<?, ?> build) {
        EnvInjectJobPropertyInfo info;
        if (build == null) {
            throw new IllegalArgumentException("A build object must be set.");
        }
        Job job = build instanceof MatrixRun ? ((MatrixRun)build).getParentBuild().getParent() : build.getParent();
        EnvInjectJobProperty envInjectJobProperty = (EnvInjectJobProperty)job.getProperty(EnvInjectJobProperty.class);
        if (envInjectJobProperty != null && (info = envInjectJobProperty.getInfo()) != null && envInjectJobProperty.isOn()) {
            return envInjectJobProperty;
        }
        return null;
    }

    @NonNull
    public static Map<String, String> getEnvVarsPreviousSteps(@NonNull Run<?, ?> build, @NonNull EnvInjectLogger logger) throws IOException, InterruptedException, EnvInjectException {
        EnvInjectPluginAction envInjectAction;
        EnvironmentList environmentList;
        HashMap<String, String> result = new HashMap<String, String>();
        if (build instanceof AbstractBuild && (environmentList = ((AbstractBuild)build).getEnvironments()) != null) {
            for (Environment e : environmentList) {
                if (e == null) continue;
                e.buildEnvVars(result);
            }
        }
        if ((envInjectAction = (EnvInjectPluginAction)build.getAction(EnvInjectPluginAction.class)) != null) {
            result.putAll(RunHelper.getCurrentInjectedEnvVars(envInjectAction));
            if (build instanceof MatrixRun) {
                result.putAll(((MatrixRun)build).getBuildVariables());
            }
        } else {
            result.putAll(EnvInjectVariableGetter.getJenkinsSystemEnvVars(false));
            result.putAll(RunHelper.getBuildVariables(build, logger));
        }
        return result;
    }

    @NonNull
    private static Map<String, String> getCurrentInjectedEnvVars(@NonNull EnvInjectPluginAction envInjectPluginAction) {
        Map envVars = envInjectPluginAction.getEnvMap();
        return envVars == null ? new HashMap() : envVars;
    }
}

