/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.FilePath;
import hudson.Launcher;
import hudson.Util;
import hudson.tasks.BatchFile;
import hudson.tasks.Shell;
import hudson.util.ArgumentListBuilder;
import java.io.IOException;
import java.util.Map;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;

public class EnvInjectScriptExecutor {
    @NonNull
    private final Launcher launcher;
    @NonNull
    private final EnvInjectLogger logger;

    public EnvInjectScriptExecutor(@NonNull Launcher launcher, @NonNull EnvInjectLogger logger) {
        this.launcher = launcher;
        this.logger = logger;
    }

    public int executeScriptSection(@CheckForNull FilePath scriptExecutionRoot, @CheckForNull String scriptFilePath, @CheckForNull String scriptContent, @NonNull Map<String, String> scriptPathExecutionEnvVars, @NonNull Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        int resultCode;
        String scriptFilePathResolved;
        String scriptFilePathNormalized;
        int resultCode2;
        if (scriptFilePath != null && (resultCode2 = this.executeScriptPath(scriptExecutionRoot, scriptFilePathNormalized = (scriptFilePathResolved = Util.replaceMacro((String)scriptFilePath, scriptPathExecutionEnvVars)).replace("\\", "/"), scriptExecutionEnvVars)) != 0) {
            return resultCode2;
        }
        if (scriptContent != null && (resultCode = this.executeScriptContent(scriptExecutionRoot, scriptContent, scriptExecutionEnvVars)) != 0) {
            return resultCode;
        }
        return 0;
    }

    private int executeScriptPath(@CheckForNull FilePath scriptExecutionRoot, @NonNull String scriptFilePath, @NonNull Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        try {
            this.launcher.getListener().getLogger().println(String.format("Executing '%s'.", scriptFilePath));
            ArgumentListBuilder cmds = new ArgumentListBuilder();
            cmds.addTokenized(scriptFilePath);
            int cmdCode = this.launcher.launch().cmds(cmds).stdout(this.launcher.getListener()).envs(scriptExecutionEnvVars).pwd(scriptExecutionRoot).join();
            if (cmdCode != 0) {
                this.logger.info(String.format("Script executed. The exit code is %s.", cmdCode));
            } else {
                this.logger.info("Script executed successfully.");
            }
            return cmdCode;
        }
        catch (Throwable e) {
            throw new EnvInjectException("Error occurs on execution script file path.", e);
        }
    }

    private int executeScriptContent(@NonNull FilePath scriptExecutionRoot, @NonNull String scriptContent, @NonNull Map<String, String> scriptExecutionEnvVars) throws EnvInjectException {
        try {
            Object batchRunner = this.launcher.isUnix() ? new Shell(scriptContent) : new BatchFile(scriptContent);
            FilePath tmpFile = batchRunner.createScriptFile(scriptExecutionRoot);
            this.logger.info(String.format("Executing and processing the following script content: %n%s%n", scriptContent));
            int cmdCode = this.launcher.launch().cmds(batchRunner.buildCommandLine(tmpFile)).stdout(this.launcher.getListener()).envs(scriptExecutionEnvVars).pwd(scriptExecutionRoot).join();
            if (cmdCode != 0) {
                this.logger.info(String.format("Script executed. The exit code is %s.", cmdCode));
            } else {
                this.logger.info("Script executed successfully.");
            }
            return cmdCode;
        }
        catch (IOException ioe) {
            throw new EnvInjectException("Error occurs on execution script file path", (Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException("Error occurs on execution script file path", (Throwable)ie);
        }
    }
}

