/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.envinject.service;

import edu.umd.cs.findbugs.annotations.CheckForNull;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.FilePath;
import hudson.model.Node;
import hudson.model.Run;
import hudson.remoting.Callable;
import hudson.slaves.EnvironmentVariablesNodeProperty;
import hudson.slaves.NodeProperty;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import jenkins.model.Jenkins;
import org.jenkinsci.lib.envinject.EnvInjectException;
import org.jenkinsci.lib.envinject.EnvInjectLogger;
import org.jenkinsci.plugins.envinject.service.EnvInjectEnvVars;
import org.jenkinsci.plugins.envinject.service.EnvInjectMasterEnvVarsRetriever;

public class EnvironmentVariablesNodeLoader
implements Serializable {
    @Deprecated
    public EnvironmentVariablesNodeLoader() {
    }

    @Deprecated
    @NonNull
    public Map<String, String> gatherEnvironmentVariablesNode(@NonNull Run<?, ?> build, @CheckForNull Node buildNode, @NonNull EnvInjectLogger logger) throws EnvInjectException {
        return EnvironmentVariablesNodeLoader.gatherEnvVarsForNode(build, buildNode, logger);
    }

    @NonNull
    public static Map<String, String> gatherEnvVarsForNode(@NonNull Run<?, ?> build, @CheckForNull Node buildNode, @NonNull EnvInjectLogger logger) throws EnvInjectException {
        logger.info("Loading node environment variables.");
        if (buildNode == null) {
            return Collections.emptyMap();
        }
        FilePath nodePath = buildNode.getRootPath();
        if (nodePath == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> configNodeEnvVars = new HashMap<String, String>();
        try {
            EnvInjectEnvVars envInjectEnvVars;
            EnvVars envVars;
            EnvironmentVariablesNodeProperty variablesNodeProperty;
            Map nodeEnvVars = (Map)nodePath.act((Callable)new EnvInjectMasterEnvVarsRetriever());
            for (NodeProperty nodeProperty : Jenkins.get().getGlobalNodeProperties()) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                variablesNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                envVars = variablesNodeProperty.getEnvVars();
                envInjectEnvVars = new EnvInjectEnvVars(logger);
                configNodeEnvVars.putAll((Map<String, String>)envVars);
                envInjectEnvVars.resolveVars(configNodeEnvVars, nodeEnvVars);
            }
            for (NodeProperty nodeProperty : buildNode.getNodeProperties()) {
                if (!(nodeProperty instanceof EnvironmentVariablesNodeProperty)) continue;
                variablesNodeProperty = (EnvironmentVariablesNodeProperty)nodeProperty;
                envVars = variablesNodeProperty.getEnvVars();
                envInjectEnvVars = new EnvInjectEnvVars(logger);
                configNodeEnvVars.putAll((Map<String, String>)envVars);
                envInjectEnvVars.resolveVars(configNodeEnvVars, nodeEnvVars);
            }
            return configNodeEnvVars;
        }
        catch (IOException ioe) {
            throw new EnvInjectException((Throwable)ioe);
        }
        catch (InterruptedException ie) {
            throw new EnvInjectException((Throwable)ie);
        }
    }
}

