/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.dsl;

import edu.umd.cs.findbugs.annotations.NonNull;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.util.HashSet;
import java.util.Set;
import org.jenkinsci.plugins.badge.EmbeddableBadgeConfig;
import org.jenkinsci.plugins.badge.actions.EmbeddableBadgeConfigsAction;
import org.jenkinsci.plugins.badge.annotations.OptionalParam;
import org.jenkinsci.plugins.badge.annotations.Param;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.jenkinsci.plugins.workflow.steps.SynchronousStepExecution;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class AddEmbeddableBadgeConfigStep
extends Step {
    final EmbeddableBadgeConfig badgeConfig;

    @DataBoundConstructor
    public AddEmbeddableBadgeConfigStep(@Param(name="id", description="The id for the badge configuration") String id) {
        this.badgeConfig = new EmbeddableBadgeConfig(id);
    }

    public String getID() {
        return this.badgeConfig.getID();
    }

    public String getSubject() {
        return this.badgeConfig.getSubject();
    }

    @DataBoundSetter
    @OptionalParam(description="The subject used for the badge configuration")
    public void setSubject(String subject) {
        this.badgeConfig.setSubject(subject);
    }

    public String getStatus() {
        return this.badgeConfig.getStatus();
    }

    @DataBoundSetter
    @OptionalParam(description="The status used for the badge configuration")
    public void setStatus(String status) {
        this.badgeConfig.setStatus(status);
    }

    public String getColor() {
        return this.badgeConfig.getColor();
    }

    @DataBoundSetter
    @OptionalParam(description="The color used for the badge configuration")
    public void setColor(String color) {
        this.badgeConfig.setColor(color);
    }

    public String getAnimatedOverlayColor() {
        return this.badgeConfig.getAnimatedOverlayColor();
    }

    @DataBoundSetter
    @OptionalParam(description="The animated overlay color used for the badge configuration")
    public void setAnimatedOverlayColor(String animatedOverlayColor) {
        this.badgeConfig.setAnimatedOverlayColor(animatedOverlayColor);
    }

    public String getLink() {
        return this.badgeConfig.getLink();
    }

    @DataBoundSetter
    @OptionalParam(description="The link the will be followed when clicking on the svg")
    public void setLink(String link) {
        this.badgeConfig.setLink(link);
    }

    public StepExecution start(StepContext context) {
        return new Execution(this.badgeConfig, context);
    }

    public static class Execution
    extends SynchronousStepExecution<EmbeddableBadgeConfig> {
        @SuppressFBWarnings(value={"SE_TRANSIENT_FIELD_NOT_RESTORED"}, justification="Only used when starting.")
        private final transient EmbeddableBadgeConfig badgeConfig;
        private static final long serialVersionUID = 1L;

        Execution(EmbeddableBadgeConfig badgeConfig, StepContext context) {
            super(context);
            this.badgeConfig = badgeConfig;
        }

        protected EmbeddableBadgeConfig run() throws Exception {
            EmbeddableBadgeConfigsAction cfgsAction = (EmbeddableBadgeConfigsAction)((Run)this.getContext().get(Run.class)).getAction(EmbeddableBadgeConfigsAction.class);
            if (cfgsAction == null) {
                cfgsAction = new EmbeddableBadgeConfigsAction();
                ((Run)this.getContext().get(Run.class)).addAction((Action)cfgsAction);
            }
            cfgsAction.addConfig(this.badgeConfig);
            return this.badgeConfig;
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "addEmbeddableBadgeConfiguration";
        }

        @NonNull
        public String getDisplayName() {
            return "Add an Embeddable Badge Configuration";
        }

        public Set<Class<?>> getRequiredContext() {
            HashSet set = new HashSet();
            set.add(TaskListener.class);
            return set;
        }
    }
}

