/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import hudson.model.Actionable;
import hudson.model.BallColor;
import hudson.model.Job;
import hudson.model.Run;
import org.jenkinsci.plugins.badge.EmbeddableBadgeConfig;
import org.jenkinsci.plugins.badge.ImageResolver;
import org.jenkinsci.plugins.badge.ParameterResolver;
import org.jenkinsci.plugins.badge.StatusImage;
import org.jenkinsci.plugins.badge.actions.EmbeddableBadgeConfigsAction;

public class IconRequestHandler {
    private final ImageResolver iconResolver = new ImageResolver();
    private final ParameterResolver parameterResolver = new ParameterResolver();

    public StatusImage handleIconRequest(String style, String subject, String status, String color, String animatedOverlayColor, String link) {
        return this.iconResolver.getImage(BallColor.BLUE, style, subject, status, color, animatedOverlayColor, link);
    }

    public StatusImage handleIconRequestForJob(Job job, String style, String subject, String status, String color, String animatedOverlayColor, String config, String link) {
        if (job != null) {
            subject = this.parameterResolver.resolve((Actionable)job, subject);
            status = this.parameterResolver.resolve((Actionable)job, status);
            color = this.parameterResolver.resolve((Actionable)job, color);
            animatedOverlayColor = this.parameterResolver.resolve((Actionable)job, animatedOverlayColor);
            link = this.parameterResolver.resolve((Actionable)job, link);
            if (config != null && (subject == null || status == null || color == null || animatedOverlayColor == null || link == null)) {
                EmbeddableBadgeConfig badgeConfig = EmbeddableBadgeConfigsAction.resolve(job, config);
                if (badgeConfig != null) {
                    if (subject == null) {
                        subject = badgeConfig.getSubject();
                    }
                    if (status == null) {
                        status = badgeConfig.getStatus();
                    }
                    if (color == null) {
                        color = badgeConfig.getColor();
                    }
                    if (animatedOverlayColor == null) {
                        animatedOverlayColor = badgeConfig.getAnimatedOverlayColor();
                    }
                    if (link == null) {
                        link = badgeConfig.getLink();
                    }
                } else {
                    if (status == null) {
                        status = "not run";
                    }
                    if (color == null) {
                        color = "lightgrey";
                    }
                }
            }
            return this.iconResolver.getImage(job.getIconColor(), style, subject, status, color, animatedOverlayColor, link);
        }
        return this.iconResolver.getImage(BallColor.NOTBUILT, style, subject, null, null, null, null);
    }

    public StatusImage handleIconRequestForRun(Run run, String style, String subject, String status, String color, String animatedOverlayColor, String config, String link) {
        if (run != null) {
            subject = this.parameterResolver.resolve((Actionable)run, subject);
            status = this.parameterResolver.resolve((Actionable)run, status);
            color = this.parameterResolver.resolve((Actionable)run, color);
            animatedOverlayColor = this.parameterResolver.resolve((Actionable)run, animatedOverlayColor);
            link = this.parameterResolver.resolve((Actionable)run, link);
            if (config != null && (subject == null || status == null || color == null || animatedOverlayColor == null || link == null)) {
                EmbeddableBadgeConfig badgeConfig = EmbeddableBadgeConfigsAction.resolve(run, config);
                if (badgeConfig != null) {
                    if (subject == null) {
                        subject = badgeConfig.getSubject();
                    }
                    if (status == null) {
                        status = badgeConfig.getStatus();
                    }
                    if (color == null) {
                        color = badgeConfig.getColor();
                    }
                    if (animatedOverlayColor == null) {
                        animatedOverlayColor = badgeConfig.getAnimatedOverlayColor();
                    }
                    if (link == null) {
                        link = badgeConfig.getLink();
                    }
                } else {
                    if (status == null) {
                        status = "not run";
                    }
                    if (color == null) {
                        color = "lightgrey";
                    }
                }
            }
            return this.iconResolver.getImage(run.getIconColor(), style, subject, status, color, animatedOverlayColor, link);
        }
        return this.iconResolver.getImage(BallColor.NOTBUILT, style, subject, null, null, null, null);
    }
}

