/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.actions;

import hudson.Extension;
import hudson.ExtensionList;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.UnprotectedRootAction;
import hudson.security.ACL;
import hudson.security.ACLContext;
import hudson.security.Permission;
import hudson.security.PermissionScope;
import hudson.util.HttpResponses;
import java.io.IOException;
import java.util.Iterator;
import jenkins.model.Jenkins;
import org.jenkinsci.plugins.badge.IconRequestHandler;
import org.jenkinsci.plugins.badge.Messages;
import org.jenkinsci.plugins.badge.PluginImpl;
import org.jenkinsci.plugins.badge.extensionpoints.InternalRunSelectorExtensionPoint;
import org.jenkinsci.plugins.badge.extensionpoints.JobSelectorExtensionPoint;
import org.jenkinsci.plugins.badge.extensionpoints.RunSelectorExtensionPoint;
import org.kohsuke.stapler.HttpResponse;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.StaplerResponse2;
import org.kohsuke.stapler.WebMethod;
import org.springframework.security.core.Authentication;

@Extension
public class PublicBuildStatusAction
implements UnprotectedRootAction {
    public static final Permission VIEW_STATUS = new Permission(Item.PERMISSIONS, "ViewStatus", Messages._ViewStatus_Permission(), Item.READ, PermissionScope.ITEM);
    private static final Jenkins jInstance = Jenkins.get();
    private IconRequestHandler iconRequestHandler = new IconRequestHandler();

    public String getUrlName() {
        return "buildStatus";
    }

    public String getIconFileName() {
        return null;
    }

    public String getDisplayName() {
        return null;
    }

    @WebMethod(name={"icon"})
    public HttpResponse doIcon(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job, @QueryParameter String build, @QueryParameter String style, @QueryParameter String subject, @QueryParameter String status, @QueryParameter String color, @QueryParameter String animatedOverlayColor, @QueryParameter String config, @QueryParameter String link) {
        if (job == null) {
            return PluginImpl.iconRequestHandler.handleIconRequest(style, subject, status, color, animatedOverlayColor, link);
        }
        Job<?, ?> project = PublicBuildStatusAction.getProject(job, false);
        if (build != null && project != null) {
            Run<?, ?> run = PublicBuildStatusAction.getRun(project, build, false);
            return this.iconRequestHandler.handleIconRequestForRun(run, style, subject, status, color, animatedOverlayColor, config, link);
        }
        return this.iconRequestHandler.handleIconRequestForJob(project, style, subject, status, color, animatedOverlayColor, config, link);
    }

    @WebMethod(name={"icon.svg"})
    public HttpResponse doIconDotSvg(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job, @QueryParameter String build, @QueryParameter String style, @QueryParameter String subject, @QueryParameter String status, @QueryParameter String color, @QueryParameter String animatedOverlayColor, @QueryParameter String config, @QueryParameter String link) {
        return this.doIcon(req, rsp, job, build, style, subject, status, color, animatedOverlayColor, config, link);
    }

    public String doText(StaplerRequest2 req, StaplerResponse2 rsp, @QueryParameter String job, @QueryParameter String build) {
        if (job == null) {
            return "Missing query parameter: job";
        }
        Job<?, ?> project = PublicBuildStatusAction.getProject(job, true);
        if (build != null) {
            Run<?, ?> run = PublicBuildStatusAction.getRun(project, build, true);
            return run.getIconColor().getDescription();
        }
        return project.getIconColor().getDescription();
    }

    private static Job<?, ?> getProject(String job, Boolean throwErrorWhenNotFound) {
        Job p = null;
        if (job != null) {
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                JobSelectorExtensionPoint jobSelector;
                Iterator iterator = ExtensionList.lookup(JobSelectorExtensionPoint.class).iterator();
                while (iterator.hasNext() && (p = (jobSelector = (JobSelectorExtensionPoint)iterator.next()).select(job)) == null) {
                }
                if (p == null) {
                    p = (Job)jInstance.getItemByFullName(job, Job.class);
                }
            }
        }
        if (p == null || !p.hasPermission(VIEW_STATUS)) {
            if (throwErrorWhenNotFound.booleanValue()) {
                throw HttpResponses.notFound();
            }
            return null;
        }
        return p;
    }

    public static Run<?, ?> getRun(Job<?, ?> project, String build, Boolean throwErrorWhenNotFound) {
        Run run = null;
        if (project != null && build != null) {
            try (ACLContext ctx = ACL.as2((Authentication)ACL.SYSTEM2);){
                for (String token : build.split(",")) {
                    Object runSelector;
                    Run newRun = null;
                    Iterator iterator = ExtensionList.lookup(InternalRunSelectorExtensionPoint.class).iterator();
                    while (iterator.hasNext() && (newRun = (runSelector = (InternalRunSelectorExtensionPoint)iterator.next()).select(project, token, run)) == null) {
                    }
                    if (newRun == null) {
                        iterator = ExtensionList.lookup(RunSelectorExtensionPoint.class).iterator();
                        while (iterator.hasNext() && (newRun = (runSelector = (RunSelectorExtensionPoint)iterator.next()).select(project, token, run)) == null) {
                        }
                    }
                    if (newRun != null) {
                        run = newRun;
                        continue;
                    }
                    break;
                }
            }
        }
        if (run == null || !run.hasPermission(VIEW_STATUS)) {
            if (throwErrorWhenNotFound.booleanValue()) {
                throw HttpResponses.notFound();
            }
            return null;
        }
        return run;
    }
}

