/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge.extensions;

import hudson.Extension;
import hudson.model.Job;
import hudson.model.ParameterValue;
import hudson.model.ParametersAction;
import hudson.model.Result;
import hudson.model.Run;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jenkinsci.plugins.badge.extensionpoints.InternalRunSelectorExtensionPoint;

@Extension
public class BuildParameterRunSelectorExtension
implements InternalRunSelectorExtensionPoint {
    private static Pattern outerSelector = Pattern.compile("(last|first)(Failed|Successful|Unsuccessful|Stable|Unstable|Completed){0,1}(:\\$\\{([^\\{\\}\\s]+)\\}){0,1}");
    private static Pattern paramsPattern = Pattern.compile("params\\.([^=]+)=(.*)");

    private Boolean matchRule(Job job, Run run, String rule) {
        if (rule == null) {
            return true;
        }
        Matcher matcher = paramsPattern.matcher(rule);
        if (matcher.find()) {
            ParameterValue value;
            String paramName = matcher.group(1);
            String paramValue = matcher.group(2);
            ParametersAction params = (ParametersAction)run.getAction(ParametersAction.class);
            if (params != null && (value = params.getParameter(paramName)) != null && value.getValue() != null && value.getValue().toString().equals(paramValue)) {
                return true;
            }
        }
        return false;
    }

    private Run findSpecific(Job job, Run run, String what, String specific) {
        if (run == null) {
            if ("first".equals(what)) {
                run = this.findSpecific(job, job.getFirstBuild(), what, specific);
            } else {
                if (specific != null) {
                    switch (specific) {
                        case "Failed": {
                            run = job.getLastFailedBuild();
                            break;
                        }
                        case "Successful": {
                            run = job.getLastSuccessfulBuild();
                            break;
                        }
                        case "Unsuccessful": {
                            run = job.getLastUnsuccessfulBuild();
                            break;
                        }
                        case "Stable": {
                            run = job.getLastStableBuild();
                            break;
                        }
                        case "Unstable": {
                            run = job.getLastUnstableBuild();
                            break;
                        }
                        case "Completed": {
                            run = job.getLastCompletedBuild();
                            break;
                        }
                    }
                }
                if (run == null) {
                    run = job.getLastBuild();
                }
            }
        } else {
            do {
                Result result;
                boolean doBreak;
                if ((run = "first".equals(what) ? run.getNextBuild() : run.getPreviousBuild()) == null) continue;
                boolean bl = doBreak = specific == null;
                if (!doBreak && (result = run.getResult()) != null) {
                    boolean isCompleted = result.isCompleteBuild();
                    boolean isSuccessful = result == Result.SUCCESS;
                    boolean isFailed = result == Result.FAILURE;
                    boolean isUnstable = result == Result.UNSTABLE;
                    boolean isUnsuccessful = !isSuccessful;
                    boolean isStable = isSuccessful;
                    boolean bl2 = doBreak = "Completed".equals(specific) && isCompleted || "Successful".equals(specific) && isCompleted && isSuccessful || "Failed".equals(specific) && isCompleted && isFailed || "Unstable".equals(specific) && isCompleted && isUnstable || "Unsuccessful".equals(specific) && isCompleted && isUnsuccessful || "Stable".equals(specific) && isCompleted && isStable;
                }
                if (doBreak) break;
            } while (run != null);
        }
        return run;
    }

    @Override
    public Run select(Job job, String runId, Run run) {
        Matcher matcher = outerSelector.matcher(runId);
        while (matcher.find()) {
            String what = matcher.group(1);
            String specific = matcher.group(2);
            String rule = matcher.group(4);
            if (run == null) {
                run = this.findSpecific(job, null, what, specific);
            }
            while (run != null && !this.matchRule(job, run, rule).booleanValue()) {
                run = this.findSpecific(job, run, what, specific);
            }
            runId = matcher.replaceAll("");
            matcher = outerSelector.matcher(runId);
        }
        return run;
    }
}

