/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.badge;

import java.io.Serializable;
import java.util.Map;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;

public class EmbeddableBadgeConfig
implements Serializable {
    private static final long serialVersionUID = 1L;
    private static final Map<String, String> COLORS = Map.of("failing", "red", "passing", "brightgreen", "unstable", "yellow", "aborted", "aborted", "running", "blue");
    private final String id;
    private String subject;
    private String status;
    private String color;
    private String animatedOverlayColor;
    private String link;

    public EmbeddableBadgeConfig(String id) {
        this.id = id;
    }

    public String getID() {
        return this.id;
    }

    public String getSubject() {
        return this.subject;
    }

    @Whitelisted
    public void setSubject(String subject) {
        this.subject = subject;
    }

    public String getStatus() {
        return this.status;
    }

    @Whitelisted
    public void setStatus(String status) {
        this.status = status;
    }

    public String getColor() {
        if (this.color == null) {
            return this.status != null ? COLORS.get(this.status) : null;
        }
        return this.color;
    }

    @Whitelisted
    public void setColor(String color) {
        this.color = color;
    }

    public String getAnimatedOverlayColor() {
        if (this.animatedOverlayColor == null && this.color == null && "running".equals(this.status)) {
            return "blue";
        }
        return this.animatedOverlayColor;
    }

    @Whitelisted
    public void setAnimatedOverlayColor(String animatedOverlayColor) {
        this.animatedOverlayColor = animatedOverlayColor;
    }

    public String getLink() {
        return this.link;
    }

    @Whitelisted
    public void setLink(String link) {
        this.link = link;
    }
}

