/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.elasticaxisplugin;

import hudson.Extension;
import hudson.matrix.Axis;
import hudson.matrix.AxisDescriptor;
import hudson.matrix.LabelAxis;
import hudson.matrix.MatrixBuild;
import hudson.model.AutoCompletionCandidates;
import hudson.model.Computer;
import hudson.model.Descriptor;
import hudson.model.Item;
import hudson.model.Job;
import hudson.model.Label;
import hudson.model.Node;
import hudson.model.labels.LabelExpression;
import hudson.util.FormValidation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.jenkinsci.plugins.elasticaxisplugin.Messages;
import org.kohsuke.stapler.AncestorInPath;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.QueryParameter;
import org.kohsuke.stapler.StaplerRequest2;
import org.kohsuke.stapler.interceptor.RequirePOST;

public class ElasticAxis
extends LabelAxis {
    private static final Logger LOGGER = Logger.getLogger(ElasticAxis.class.getName());
    private final String label;
    private final boolean ignoreOffline;
    private final boolean dontExpandLabels;

    @DataBoundConstructor
    public ElasticAxis(String name, String labelString, boolean ignoreOffline, boolean dontExpandLabels) {
        super(name, ElasticAxis.computeAllNodesInLabel(labelString, dontExpandLabels));
        this.label = labelString;
        this.ignoreOffline = ignoreOffline;
        this.dontExpandLabels = dontExpandLabels;
    }

    public String getLabelString() {
        return this.label;
    }

    public boolean getIgnoreOffline() {
        return this.ignoreOffline;
    }

    public boolean getDontExpandLabels() {
        return this.dontExpandLabels;
    }

    public List<String> rebuild(MatrixBuild.MatrixBuildExecution context) {
        return ElasticAxis.computeNodesInLabel(this.label, this.ignoreOffline, this.dontExpandLabels);
    }

    public List<String> getValues() {
        return ElasticAxis.computeAllNodesInLabel(this.label, this.dontExpandLabels);
    }

    private static List<String> computeAllNodesInLabel(String labelName, Boolean dontExpandLabels) {
        return ElasticAxis.computeNodesInLabel(labelName, false, dontExpandLabels);
    }

    private static List<String> computeNodesInLabel(String labelWithNodes, boolean restrictToOnlineNodes, boolean dontExpandLabels) {
        String[] labels;
        ArrayList<String> computedNodes = new ArrayList<String>();
        for (String aLabel : labels = labelWithNodes.split(",")) {
            if (!dontExpandLabels) {
                Label agentLabel = Jenkins.get().getLabel(aLabel.trim());
                if (agentLabel == null) continue;
                for (Node node : agentLabel.getNodes()) {
                    if (!ElasticAxis.shouldAddNode(restrictToOnlineNodes, node.toComputer())) continue;
                    computedNodes.add(node.getSelfLabel().getExpression());
                }
                continue;
            }
            boolean onlineNodesForLabel = false;
            Label agentLabel = Jenkins.get().getLabel(aLabel.trim());
            if (agentLabel == null) continue;
            for (Node node : agentLabel.getNodes()) {
                if (!ElasticAxis.shouldAddNode(restrictToOnlineNodes, node.toComputer())) continue;
                onlineNodesForLabel = true;
            }
            if (!onlineNodesForLabel) continue;
            computedNodes.add(agentLabel.getExpression());
        }
        return Collections.unmodifiableList(computedNodes);
    }

    private static boolean shouldAddNode(boolean restrictToOnlineNodes, Computer c) {
        if (c == null) {
            return true;
        }
        if (!restrictToOnlineNodes) {
            return true;
        }
        boolean isNodeAvailable = (c.isOnline() || c.isConnecting()) && c.isAcceptingTasks();
        return isNodeAvailable;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        ElasticAxis that = (ElasticAxis)((Object)o);
        return Objects.equals(this.getName(), that.getName()) && Objects.equals(this.label, that.label) && Objects.equals(this.ignoreOffline, that.ignoreOffline) && Objects.equals(this.dontExpandLabels, that.dontExpandLabels);
    }

    public int hashCode() {
        return Objects.hash(this.getName(), this.label, this.ignoreOffline, this.dontExpandLabels);
    }

    @Extension
    public static class DescriptorImpl
    extends AxisDescriptor {
        public String getDisplayName() {
            return Messages.ElasticAxisDisplayName();
        }

        public Axis newInstance(StaplerRequest2 req, JSONObject formData) throws Descriptor.FormException {
            return new ElasticAxis(formData.getString("name"), formData.getString("labelString"), formData.getBoolean("ignoreOffline"), formData.getBoolean("dontExpandLabels"));
        }

        @RequirePOST
        public FormValidation doCheckLabelString(@AncestorInPath Job<?, ?> job, @QueryParameter String value) {
            job.checkPermission(Item.CONFIGURE);
            Object[] labels = value.split(",");
            ArrayList<FormValidation> aggregatedNotOkValidations = new ArrayList<FormValidation>();
            for (String string : labels) {
                FormValidation validation = LabelExpression.validate((String)string, job);
                if (validation.equals(FormValidation.ok())) continue;
                LOGGER.log(Level.FINEST, "Remembering not ok validation {1} for label {0}", new Object[]{string, validation});
                aggregatedNotOkValidations.add(validation);
            }
            if (!aggregatedNotOkValidations.isEmpty()) {
                FormValidation aggregatedValidations = FormValidation.aggregate(aggregatedNotOkValidations);
                LOGGER.log(Level.FINEST, "Returning aggregated not ok validation {1} for labels {0}", new Object[]{labels, aggregatedValidations});
                return aggregatedValidations;
            }
            LOGGER.log(Level.FINEST, "Returning ok validation for labels {0}", labels);
            return FormValidation.ok();
        }

        @RequirePOST
        public AutoCompletionCandidates doAutoCompleteLabelString(@QueryParameter String value) {
            return LabelExpression.autoComplete((String)value);
        }
    }
}

