/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.declarative;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.Util;
import hudson.util.FormValidation;
import org.apache.commons.lang.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.workflow.declarative.AbstractDockerAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.QueryParameter;

public class DockerPipeline
extends AbstractDockerAgent<DockerPipeline> {
    private String image;
    private boolean alwaysPull;

    @DataBoundConstructor
    public DockerPipeline(@NonNull String image) {
        this.image = image;
    }

    @NonNull
    public String getImage() {
        return this.image;
    }

    @DataBoundSetter
    public void setAlwaysPull(boolean alwaysPull) {
        this.alwaysPull = alwaysPull;
    }

    public boolean isAlwaysPull() {
        return this.alwaysPull;
    }

    @Extension(ordinal=1000.0)
    @Symbol(value={"docker"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<DockerPipeline> {
        @NonNull
        public String getDisplayName() {
            return "Run inside a Docker container";
        }

        public FormValidation doCheckImage(@QueryParameter String image) {
            if (StringUtils.isEmpty((String)Util.fixEmptyAndTrim((String)image))) {
                return FormValidation.error((String)"Image is required.");
            }
            return FormValidation.ok();
        }
    }
}

