/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.declarative;

import com.google.inject.Inject;
import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.Extension;
import hudson.ExtensionList;
import hudson.Util;
import hudson.model.Descriptor;
import hudson.model.Run;
import hudson.util.XStream2;
import java.io.File;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;
import jenkins.model.GlobalConfiguration;
import jenkins.model.Jenkins;
import net.sf.json.JSONObject;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.commons.credentials.DockerRegistryEndpoint;
import org.jenkinsci.plugins.docker.workflow.declarative.DockerPropertiesProvider;
import org.kohsuke.stapler.DataBoundSetter;
import org.kohsuke.stapler.StaplerRequest2;

@Extension
@Symbol(value={"pipeline-model-docker", "pipeline-model"})
public class GlobalConfig
extends GlobalConfiguration {
    private static final Logger LOGGER = Logger.getLogger(GlobalConfig.class.getName());
    private String dockerLabel;
    private DockerRegistryEndpoint registry;

    public GlobalConfig() {
        String oldId = "org.jenkinsci.plugins.pipeline.modeldefinition.config.GlobalConfig";
        File oldConfigFile = new File(Jenkins.get().getRootDir(), oldId + ".xml");
        File newConfigFile = new File(Jenkins.get().getRootDir(), this.getId() + ".xml");
        if (oldConfigFile.exists() && !newConfigFile.exists()) {
            try {
                FileUtils.moveFile((File)oldConfigFile, (File)newConfigFile);
                LOGGER.info("migrated " + String.valueOf(oldConfigFile) + " to " + String.valueOf(newConfigFile));
            }
            catch (IOException x) {
                LOGGER.log(Level.WARNING, null, x);
            }
        }
        ((XStream2)this.getConfigFile().getXStream()).addCompatibilityAlias(oldId, GlobalConfig.class);
        this.load();
    }

    public String getDockerLabel() {
        return Util.fixEmpty((String)this.dockerLabel);
    }

    @DataBoundSetter
    public void setDockerLabel(String dockerLabel) {
        this.dockerLabel = dockerLabel;
    }

    public DockerRegistryEndpoint getRegistry() {
        return this.registry;
    }

    @DataBoundSetter
    public void setRegistry(DockerRegistryEndpoint registry) {
        this.registry = registry;
    }

    public boolean configure(StaplerRequest2 req, JSONObject json) throws Descriptor.FormException {
        req.bindJSON((Object)this, json);
        this.save();
        return true;
    }

    public static GlobalConfig get() {
        return (GlobalConfig)((Object)ExtensionList.lookup(GlobalConfiguration.class).get(GlobalConfig.class));
    }

    @Extension(ordinal=-10000.0)
    public static final class GlobalConfigDockerPropertiesProvider
    extends DockerPropertiesProvider {
        @Inject
        GlobalConfig config;

        @Override
        public String getLabel(@Nullable Run run) {
            return this.config.getDockerLabel();
        }

        @Override
        public String getRegistryUrl(@Nullable Run run) {
            if (this.config.getRegistry() != null && !StringUtils.isBlank((CharSequence)this.config.getRegistry().getUrl())) {
                return this.config.getRegistry().getUrl();
            }
            return null;
        }

        @Override
        public String getRegistryCredentialsId(@Nullable Run run) {
            if (this.config.getRegistry() != null && !StringUtils.isBlank((CharSequence)this.config.getRegistry().getCredentialsId())) {
                return this.config.getRegistry().getCredentialsId();
            }
            return null;
        }
    }
}

