/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.declarative;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.Symbol;
import org.jenkinsci.plugins.docker.workflow.declarative.AbstractDockerAgent;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.DeclarativeAgentDescriptor;
import org.kohsuke.stapler.DataBoundConstructor;
import org.kohsuke.stapler.DataBoundSetter;

public class DockerPipelineFromDockerfile
extends AbstractDockerAgent<DockerPipelineFromDockerfile> {
    private String filename;
    private String dir;
    private String additionalBuildArgs;

    @DataBoundConstructor
    public DockerPipelineFromDockerfile() {
    }

    public Object getFilename() {
        return this.filename;
    }

    @DataBoundSetter
    public void setFilename(String filename) {
        this.filename = filename;
    }

    public String getDir() {
        return this.dir;
    }

    @DataBoundSetter
    public void setDir(String dir) {
        this.dir = dir;
    }

    public String getAdditionalBuildArgs() {
        return this.additionalBuildArgs;
    }

    @DataBoundSetter
    public void setAdditionalBuildArgs(String additionalBuildArgs) {
        this.additionalBuildArgs = additionalBuildArgs;
    }

    @NonNull
    public String getActualDir() {
        if (!StringUtils.isEmpty((CharSequence)this.dir)) {
            return this.dir;
        }
        return ".";
    }

    @NonNull
    public String getDockerfilePath(boolean isUnix) {
        StringBuilder fullPath = new StringBuilder();
        if (!StringUtils.isEmpty((CharSequence)this.dir)) {
            fullPath.append(this.dir);
            if (isUnix) {
                fullPath.append('/');
            } else {
                fullPath.append('\\');
            }
        }
        fullPath.append(this.getDockerfileAsString());
        return fullPath.toString();
    }

    @NonNull
    public String getDockerfileAsString() {
        if (this.filename != null) {
            return this.filename;
        }
        return "Dockerfile";
    }

    @Extension(ordinal=999.0)
    @Symbol(value={"dockerfile"})
    public static class DescriptorImpl
    extends DeclarativeAgentDescriptor<DockerPipelineFromDockerfile> {
        @NonNull
        public String getDisplayName() {
            return "Build a Dockerfile and run in a container using that image";
        }
    }
}

