/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.declarative;

import edu.umd.cs.findbugs.annotations.Nullable;
import hudson.model.Run;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import org.apache.commons.lang3.StringUtils;
import org.jenkinsci.plugins.docker.workflow.declarative.AbstractDockerAgent;
import org.jenkinsci.plugins.docker.workflow.declarative.DockerPropertiesProvider;
import org.jenkinsci.plugins.pipeline.modeldefinition.agent.impl.Label;
import org.jenkinsci.plugins.pipeline.modeldefinition.withscript.WithScriptScript;
import org.jenkinsci.plugins.scriptsecurity.sandbox.whitelists.Whitelisted;
import org.jenkinsci.plugins.workflow.cps.CpsFlowExecution;
import org.jenkinsci.plugins.workflow.cps.CpsScript;
import org.jenkinsci.plugins.workflow.cps.CpsThread;
import org.jenkinsci.plugins.workflow.flow.FlowExecutionOwner;

public class DeclarativeDockerUtils {
    private static final String DEFAULT_REGISTRY = "https://index.docker.io/v1/";

    private static Run<?, ?> currentRun() {
        try {
            FlowExecutionOwner o;
            CpsFlowExecution e;
            CpsThread t = CpsThread.current();
            if (t != null && (e = t.getExecution()) != null && (o = e.getOwner()) != null && o.getExecutable() instanceof Run) {
                return (Run)o.getExecutable();
            }
            return null;
        }
        catch (IOException i) {
            return null;
        }
    }

    @Whitelisted
    public static String getLabel() {
        return DeclarativeDockerUtils.getLabel(null);
    }

    @Whitelisted
    public static String getLabel(@Nullable String override) {
        if (!StringUtils.isBlank((CharSequence)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String label = provider.getLabel(r);
            if (StringUtils.isBlank((CharSequence)label)) continue;
            return label;
        }
        return null;
    }

    @Whitelisted
    public static WithScriptScript<?> getLabelScript(AbstractDockerAgent<?> describable, CpsScript script) throws Exception {
        String targetLabel = DeclarativeDockerUtils.getLabel(describable.getLabel());
        Label l = (Label)Label.DescriptorImpl.instanceForName((String)"label", Collections.singletonMap("label", targetLabel));
        l.copyFlags(describable);
        l.setCustomWorkspace(describable.getCustomWorkspace());
        return l.getScript(script);
    }

    @Whitelisted
    public static String getRegistryUrl() {
        return DeclarativeDockerUtils.getRegistryUrl(null);
    }

    @Whitelisted
    public static String getRegistryUrl(@Nullable String override) {
        if (!StringUtils.isBlank((CharSequence)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String url = provider.getRegistryUrl(r);
            if (StringUtils.isBlank((CharSequence)url)) continue;
            return url;
        }
        return null;
    }

    @Whitelisted
    public static String getRegistryCredentialsId() {
        return DeclarativeDockerUtils.getRegistryCredentialsId(null);
    }

    @Whitelisted
    public static String getRegistryCredentialsId(@Nullable String override) {
        if (!StringUtils.isBlank((CharSequence)override)) {
            return override;
        }
        Run<?, ?> r = DeclarativeDockerUtils.currentRun();
        for (DockerPropertiesProvider provider : DockerPropertiesProvider.all()) {
            String id = provider.getRegistryCredentialsId(r);
            if (StringUtils.isBlank((CharSequence)id)) continue;
            return id;
        }
        return null;
    }

    public static class DockerRegistry
    implements Serializable {
        public String registry;
        public String credential;

        public DockerRegistry(String registry, String creds) {
            this.registry = registry != null ? registry : DeclarativeDockerUtils.DEFAULT_REGISTRY;
            this.credential = creds;
        }

        public boolean hasData() {
            return this.credential != null || !this.registry.equals(DeclarativeDockerUtils.DEFAULT_REGISTRY);
        }

        public static DockerRegistry build(String dockerHub, String creds) {
            return new DockerRegistry(DeclarativeDockerUtils.getRegistryUrl(dockerHub), DeclarativeDockerUtils.getRegistryCredentialsId(creds));
        }
    }
}

