/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.BulkChange;
import hudson.Extension;
import hudson.model.Action;
import hudson.model.InvisibleAction;
import hudson.model.Job;
import hudson.model.Run;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.jenkinsci.plugins.docker.commons.DockerImageExtractor;

final class ImageAction
extends InvisibleAction {
    private final Set<String> names = new TreeSet<String>();

    ImageAction() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void add(String image, Run<?, ?> run) throws IOException {
        Run<?, ?> run2 = run;
        synchronized (run2) {
            BulkChange bc = new BulkChange(run);
            try {
                ImageAction action = (ImageAction)run.getAction(ImageAction.class);
                if (action == null) {
                    action = new ImageAction();
                    run.addAction((Action)action);
                }
                action.names.add(image);
                bc.commit();
            }
            finally {
                bc.abort();
            }
        }
    }

    @Extension
    public static final class ExtractorImpl
    extends DockerImageExtractor {
        @NonNull
        public Collection<String> getDockerImagesUsedByJob(Job<?, ?> job) {
            ImageAction action;
            Run build = job.getLastCompletedBuild();
            if (build != null && (action = (ImageAction)build.getAction(ImageAction.class)) != null) {
                TreeSet<String> bareNames = new TreeSet<String>();
                for (String name : action.names) {
                    bareNames.add(name.replaceFirst("[:@].+", ""));
                }
                return bareNames;
            }
            return Collections.emptySet();
        }
    }
}

