/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow.client;

import com.google.common.base.Optional;
import hudson.FilePath;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ControlGroup {
    public final int id;
    public final String subsystems;
    public final String group;

    private ControlGroup(String line) throws NumberFormatException, IndexOutOfBoundsException {
        String[] fields = line.split(":");
        this.id = Integer.parseInt(fields[0]);
        this.subsystems = fields[1];
        this.group = fields[2];
    }

    public static Optional<String> getContainerId(FilePath procfile) throws IOException, InterruptedException {
        return ControlGroup.getContainerId(new InputStreamReader(procfile.read(), StandardCharsets.UTF_8));
    }

    static Optional<String> getContainerId(Reader reader) throws IOException {
        try (BufferedReader r = new BufferedReader(reader);){
            String line;
            while ((line = r.readLine()) != null) {
                ControlGroup cgroup = new ControlGroup(line);
                String containerId = cgroup.getContainerId();
                if (containerId == null) continue;
                Optional optional = Optional.of((Object)containerId);
                return optional;
            }
        }
        return Optional.absent();
    }

    public String getContainerId() throws IOException {
        Matcher matcher = Pattern.compile("([a-z0-9]{64})").matcher(this.group);
        String containerId = null;
        while (matcher.find()) {
            containerId = matcher.group();
        }
        if (null == containerId && Pattern.compile("^(\\/docker\\/|\\/ecs\\/|\\/docker-|\\/kubepods\\/|\\/actions_job\\/).*").matcher(this.group).matches()) {
            throw new IOException("Unexpected cgroup syntax " + this.group);
        }
        return containerId;
    }
}

