/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import com.google.common.collect.ImmutableSet;
import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.Extension;
import hudson.FilePath;
import hudson.model.Run;
import java.io.IOException;
import java.util.Objects;
import java.util.Set;
import org.jenkinsci.plugins.docker.commons.credentials.DockerServerEndpoint;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution;
import org.jenkinsci.plugins.docker.workflow.AbstractEndpointStepExecution2;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class ServerEndpointStep
extends Step {
    @NonNull
    private final DockerServerEndpoint server;

    @DataBoundConstructor
    public ServerEndpointStep(@NonNull DockerServerEndpoint server) {
        this.server = Objects.requireNonNull(server, "server must not be null");
    }

    @NonNull
    public DockerServerEndpoint getServer() {
        return this.server;
    }

    public StepExecution start(StepContext context) throws Exception {
        return new Execution2(this, context);
    }

    private static final class Execution2
    extends AbstractEndpointStepExecution2 {
        private static final long serialVersionUID = 1L;
        private final transient ServerEndpointStep step;

        Execution2(ServerEndpointStep step, StepContext context) {
            super(context);
            this.step = step;
        }

        @Override
        protected KeyMaterialFactory newKeyMaterialFactory() throws IOException, InterruptedException {
            return this.step.server.newKeyMaterialFactory((Run)this.getContext().get(Run.class), ((FilePath)this.getContext().get(FilePath.class)).getChannel());
        }
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public String getFunctionName() {
            return "withDockerServer";
        }

        @NonNull
        public String getDisplayName() {
            return "Sets up Docker server endpoint";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }

        public boolean isAdvanced() {
            return true;
        }

        public Set<? extends Class<?>> getRequiredContext() {
            return ImmutableSet.of(Run.class, FilePath.class);
        }
    }

    @Deprecated
    public static class Execution
    extends AbstractEndpointStepExecution {
        private static final long serialVersionUID = 1L;
    }
}

