/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.workflow;

import java.util.HashMap;
import java.util.Map;
import org.apache.tools.ant.types.Commandline;
import org.jenkinsci.plugins.docker.workflow.Dockerfile;

public final class DockerUtils {
    private DockerUtils() {
    }

    public static Map<String, String> parseBuildArgs(Dockerfile dockerfile, String commandLine) {
        Commandline parsed = new Commandline(commandLine);
        HashMap<String, String> result = new HashMap<String, String>();
        if (dockerfile != null) {
            result.putAll(dockerfile.getArgs());
        }
        String[] arguments = parsed.getArguments();
        for (int i = 0; i < arguments.length; ++i) {
            String arg = arguments[i];
            if (!arg.equals("--build-arg")) continue;
            if (arguments.length <= i + 1) {
                throw new IllegalArgumentException("Missing parameter for --build-arg: " + commandLine);
            }
            String keyVal = arguments[i + 1];
            String[] parts = keyVal.split("=", 2);
            if (parts.length != 2) {
                throw new IllegalArgumentException("Illegal syntax for --build-arg " + keyVal + ", need KEY=VALUE");
            }
            String key = parts[0];
            String value = parts[1];
            result.put(key, value);
        }
        return result;
    }
}

