/*
 * Decompiled with CFR 0.152.
 */
package org.jenkinsci.plugins.docker.commons.impl;

import edu.umd.cs.findbugs.annotations.NonNull;
import hudson.EnvVars;
import hudson.remoting.VirtualChannel;
import java.io.IOException;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterial2;
import org.jenkinsci.plugins.docker.commons.credentials.KeyMaterialFactory;
import org.kohsuke.accmod.Restricted;
import org.kohsuke.accmod.restrictions.NoExternalUse;

@Restricted(value={NoExternalUse.class})
public class ServerHostKeyMaterialFactory
extends KeyMaterialFactory {
    @NonNull
    private final String host;

    public ServerHostKeyMaterialFactory(@NonNull String host) {
        this.host = host;
    }

    @Override
    public KeyMaterial2 materialize2() throws IOException, InterruptedException {
        EnvVars env = new EnvVars();
        env.put("DOCKER_HOST", this.host);
        return new KeyMaterialImpl2(env);
    }

    private static class KeyMaterialImpl2
    extends KeyMaterial2 {
        private static final long serialVersionUID = 1L;

        private KeyMaterialImpl2(EnvVars envVars) {
            super(envVars);
        }

        @Override
        public void close(VirtualChannel channel) throws IOException {
        }
    }

    @Deprecated
    private static class KeyMaterialImpl
    extends KeyMaterial {
        private static final long serialVersionUID = 1L;

        private KeyMaterialImpl() {
            super(null);
            assert (false) : "only deserialized";
        }

        @Override
        public void close() throws IOException {
        }
    }
}

